package io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IngressSpecBuilder extends IngressSpecFluentImpl<IngressSpecBuilder> implements VisitableBuilder<io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.IngressSpec,io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.IngressSpecBuilder>{
  public IngressSpecBuilder() {
    this(false);
  }
  public IngressSpecBuilder(Boolean validationEnabled) {
    this(new IngressSpec(), validationEnabled);
  }
  public IngressSpecBuilder(IngressSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public IngressSpecBuilder(io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.IngressSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new IngressSpec(), validationEnabled);
  }
  public IngressSpecBuilder(io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.IngressSpecFluent<?> fluent,io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.IngressSpec instance) {
    this(fluent, instance, false);
  }
  public IngressSpecBuilder(io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.IngressSpecFluent<?> fluent,io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.IngressSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withSslCiphers(instance.getSslCiphers()); 
    this.validationEnabled = validationEnabled; 
  }
  public IngressSpecBuilder(io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.IngressSpec instance) {
    this(instance,false);
  }
  public IngressSpecBuilder(io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.IngressSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withSslCiphers(instance.getSslCiphers()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.IngressSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.IngressSpec build() {
    IngressSpec buildable = new IngressSpec(fluent.getSslCiphers());
    return buildable;
  }
  
}