package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.Condition;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
public class ClusterManagerStatusFluentImpl<A extends io.fabric8.openclustermanagement.api.model.operator.v1.ClusterManagerStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openclustermanagement.api.model.operator.v1.ClusterManagerStatusFluent<A>{
  public ClusterManagerStatusFluentImpl() {
  }
  public ClusterManagerStatusFluentImpl(io.fabric8.openclustermanagement.api.model.operator.v1.ClusterManagerStatus instance) {
    this.withConditions(instance.getConditions()); 
    this.withGenerations(instance.getGenerations()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.withRelatedResources(instance.getRelatedResources()); 
  }
  private java.util.List<io.fabric8.kubernetes.api.model.Condition> conditions;
  private java.util.List<io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatusBuilder> generations;
  private java.lang.Long observedGeneration;
  private java.util.List<io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMetaBuilder> relatedResources;
  public A addToConditions(java.lang.Integer index,io.fabric8.kubernetes.api.model.Condition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Condition>();}
    this.conditions.add(index, item);
    return (A)this;
  }
  public A setToConditions(java.lang.Integer index,io.fabric8.kubernetes.api.model.Condition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Condition>();}
    this.conditions.set(index, item); return (A)this;
  }
  public A addToConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Condition>();}
    for (io.fabric8.kubernetes.api.model.Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  public A addAllToConditions(java.util.Collection<io.fabric8.kubernetes.api.model.Condition> items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Condition>();}
    for (io.fabric8.kubernetes.api.model.Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    for (io.fabric8.kubernetes.api.model.Condition item : items) {if (this.conditions!= null){ this.conditions.remove(item);}} return (A)this;
  }
  public A removeAllFromConditions(java.util.Collection<io.fabric8.kubernetes.api.model.Condition> items) {
    for (io.fabric8.kubernetes.api.model.Condition item : items) {if (this.conditions!= null){ this.conditions.remove(item);}} return (A)this;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.Condition> getConditions() {
    return this.conditions;
  }
  public io.fabric8.kubernetes.api.model.Condition getCondition(java.lang.Integer index) {
    return this.conditions.get(index);
  }
  public io.fabric8.kubernetes.api.model.Condition getFirstCondition() {
    return this.conditions.get(0);
  }
  public io.fabric8.kubernetes.api.model.Condition getLastCondition() {
    return this.conditions.get(conditions.size() - 1);
  }
  public io.fabric8.kubernetes.api.model.Condition getMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.Condition> predicate) {
    for (io.fabric8.kubernetes.api.model.Condition item: conditions) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.Condition> predicate) {
    for (io.fabric8.kubernetes.api.model.Condition item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(java.util.List<io.fabric8.kubernetes.api.model.Condition> conditions) {
    if (conditions != null) {this.conditions = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.kubernetes.api.model.Condition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (io.fabric8.kubernetes.api.model.Condition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public java.lang.Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public A addToGenerations(java.lang.Integer index,io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatus item) {
    if (this.generations == null) {this.generations = new java.util.ArrayList<io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatusBuilder>();}
    io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatusBuilder builder = new io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatusBuilder(item);_visitables.get("generations").add(index >= 0 ? index : _visitables.get("generations").size(), builder);this.generations.add(index >= 0 ? index : generations.size(), builder); return (A)this;
  }
  public A setToGenerations(java.lang.Integer index,io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatus item) {
    if (this.generations == null) {this.generations = new java.util.ArrayList<io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatusBuilder>();}
    io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatusBuilder builder = new io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatusBuilder(item);
    if (index < 0 || index >= _visitables.get("generations").size()) { _visitables.get("generations").add(builder); } else { _visitables.get("generations").set(index, builder);}
    if (index < 0 || index >= generations.size()) { generations.add(builder); } else { generations.set(index, builder);}
     return (A)this;
  }
  public A addToGenerations(io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatus... items) {
    if (this.generations == null) {this.generations = new java.util.ArrayList<io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatusBuilder>();}
    for (io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatus item : items) {io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatusBuilder builder = new io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatusBuilder(item);_visitables.get("generations").add(builder);this.generations.add(builder);} return (A)this;
  }
  public A addAllToGenerations(java.util.Collection<io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatus> items) {
    if (this.generations == null) {this.generations = new java.util.ArrayList<io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatusBuilder>();}
    for (io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatus item : items) {io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatusBuilder builder = new io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatusBuilder(item);_visitables.get("generations").add(builder);this.generations.add(builder);} return (A)this;
  }
  public A removeFromGenerations(io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatus... items) {
    for (io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatus item : items) {io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatusBuilder builder = new io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatusBuilder(item);_visitables.get("generations").remove(builder);if (this.generations != null) {this.generations.remove(builder);}} return (A)this;
  }
  public A removeAllFromGenerations(java.util.Collection<io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatus> items) {
    for (io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatus item : items) {io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatusBuilder builder = new io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatusBuilder(item);_visitables.get("generations").remove(builder);if (this.generations != null) {this.generations.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromGenerations(java.util.function.Predicate<io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatusBuilder> predicate) {
    if (generations == null) return (A) this;
    final Iterator<io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatusBuilder> each = generations.iterator();
    final List visitables = _visitables.get("generations");
    while (each.hasNext()) {
      io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildGenerations instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatus> getGenerations() {
    return build(generations);
  }
  public java.util.List<io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatus> buildGenerations() {
    return build(generations);
  }
  public io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatus buildGeneration(java.lang.Integer index) {
    return this.generations.get(index).build();
  }
  public io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatus buildFirstGeneration() {
    return this.generations.get(0).build();
  }
  public io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatus buildLastGeneration() {
    return this.generations.get(generations.size() - 1).build();
  }
  public io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatus buildMatchingGeneration(java.util.function.Predicate<io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatusBuilder> predicate) {
    for (io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatusBuilder item: generations) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingGeneration(java.util.function.Predicate<io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatusBuilder> predicate) {
    for (io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatusBuilder item: generations) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withGenerations(java.util.List<io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatus> generations) {
    if (this.generations != null) { _visitables.get("generations").removeAll(this.generations);}
    if (generations != null) {this.generations = new java.util.ArrayList(); for (io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatus item : generations){this.addToGenerations(item);}} else { this.generations = null;} return (A) this;
  }
  public A withGenerations(io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatus... generations) {
    if (this.generations != null) {this.generations.clear();}
    if (generations != null) {for (io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatus item :generations){ this.addToGenerations(item);}} return (A) this;
  }
  public java.lang.Boolean hasGenerations() {
    return generations != null && !generations.isEmpty();
  }
  public io.fabric8.openclustermanagement.api.model.operator.v1.ClusterManagerStatusFluent.GenerationsNested<A> addNewGeneration() {
    return new io.fabric8.openclustermanagement.api.model.operator.v1.ClusterManagerStatusFluentImpl.GenerationsNestedImpl();
  }
  public io.fabric8.openclustermanagement.api.model.operator.v1.ClusterManagerStatusFluent.GenerationsNested<A> addNewGenerationLike(io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatus item) {
    return new io.fabric8.openclustermanagement.api.model.operator.v1.ClusterManagerStatusFluentImpl.GenerationsNestedImpl(-1, item);
  }
  public io.fabric8.openclustermanagement.api.model.operator.v1.ClusterManagerStatusFluent.GenerationsNested<A> setNewGenerationLike(java.lang.Integer index,io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatus item) {
    return new io.fabric8.openclustermanagement.api.model.operator.v1.ClusterManagerStatusFluentImpl.GenerationsNestedImpl(index, item);
  }
  public io.fabric8.openclustermanagement.api.model.operator.v1.ClusterManagerStatusFluent.GenerationsNested<A> editGeneration(java.lang.Integer index) {
    if (generations.size() <= index) throw new RuntimeException("Can't edit generations. Index exceeds size.");
    return setNewGenerationLike(index, buildGeneration(index));
  }
  public io.fabric8.openclustermanagement.api.model.operator.v1.ClusterManagerStatusFluent.GenerationsNested<A> editFirstGeneration() {
    if (generations.size() == 0) throw new RuntimeException("Can't edit first generations. The list is empty.");
    return setNewGenerationLike(0, buildGeneration(0));
  }
  public io.fabric8.openclustermanagement.api.model.operator.v1.ClusterManagerStatusFluent.GenerationsNested<A> editLastGeneration() {
    int index = generations.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last generations. The list is empty.");
    return setNewGenerationLike(index, buildGeneration(index));
  }
  public io.fabric8.openclustermanagement.api.model.operator.v1.ClusterManagerStatusFluent.GenerationsNested<A> editMatchingGeneration(java.util.function.Predicate<io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<generations.size();i++) { 
    if (predicate.test(generations.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching generations. No match found.");
    return setNewGenerationLike(index, buildGeneration(index));
  }
  public java.lang.Long getObservedGeneration() {
    return this.observedGeneration;
  }
  public A withObservedGeneration(java.lang.Long observedGeneration) {
    this.observedGeneration=observedGeneration; return (A) this;
  }
  public java.lang.Boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  public A addToRelatedResources(java.lang.Integer index,io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMeta item) {
    if (this.relatedResources == null) {this.relatedResources = new java.util.ArrayList<io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMetaBuilder>();}
    io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMetaBuilder builder = new io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMetaBuilder(item);_visitables.get("relatedResources").add(index >= 0 ? index : _visitables.get("relatedResources").size(), builder);this.relatedResources.add(index >= 0 ? index : relatedResources.size(), builder); return (A)this;
  }
  public A setToRelatedResources(java.lang.Integer index,io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMeta item) {
    if (this.relatedResources == null) {this.relatedResources = new java.util.ArrayList<io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMetaBuilder>();}
    io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMetaBuilder builder = new io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMetaBuilder(item);
    if (index < 0 || index >= _visitables.get("relatedResources").size()) { _visitables.get("relatedResources").add(builder); } else { _visitables.get("relatedResources").set(index, builder);}
    if (index < 0 || index >= relatedResources.size()) { relatedResources.add(builder); } else { relatedResources.set(index, builder);}
     return (A)this;
  }
  public A addToRelatedResources(io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMeta... items) {
    if (this.relatedResources == null) {this.relatedResources = new java.util.ArrayList<io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMetaBuilder>();}
    for (io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMeta item : items) {io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMetaBuilder builder = new io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMetaBuilder(item);_visitables.get("relatedResources").add(builder);this.relatedResources.add(builder);} return (A)this;
  }
  public A addAllToRelatedResources(java.util.Collection<io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMeta> items) {
    if (this.relatedResources == null) {this.relatedResources = new java.util.ArrayList<io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMetaBuilder>();}
    for (io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMeta item : items) {io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMetaBuilder builder = new io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMetaBuilder(item);_visitables.get("relatedResources").add(builder);this.relatedResources.add(builder);} return (A)this;
  }
  public A removeFromRelatedResources(io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMeta... items) {
    for (io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMeta item : items) {io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMetaBuilder builder = new io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMetaBuilder(item);_visitables.get("relatedResources").remove(builder);if (this.relatedResources != null) {this.relatedResources.remove(builder);}} return (A)this;
  }
  public A removeAllFromRelatedResources(java.util.Collection<io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMeta> items) {
    for (io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMeta item : items) {io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMetaBuilder builder = new io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMetaBuilder(item);_visitables.get("relatedResources").remove(builder);if (this.relatedResources != null) {this.relatedResources.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromRelatedResources(java.util.function.Predicate<io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMetaBuilder> predicate) {
    if (relatedResources == null) return (A) this;
    final Iterator<io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMetaBuilder> each = relatedResources.iterator();
    final List visitables = _visitables.get("relatedResources");
    while (each.hasNext()) {
      io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMetaBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildRelatedResources instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMeta> getRelatedResources() {
    return build(relatedResources);
  }
  public java.util.List<io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMeta> buildRelatedResources() {
    return build(relatedResources);
  }
  public io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMeta buildRelatedResource(java.lang.Integer index) {
    return this.relatedResources.get(index).build();
  }
  public io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMeta buildFirstRelatedResource() {
    return this.relatedResources.get(0).build();
  }
  public io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMeta buildLastRelatedResource() {
    return this.relatedResources.get(relatedResources.size() - 1).build();
  }
  public io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMeta buildMatchingRelatedResource(java.util.function.Predicate<io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMetaBuilder> predicate) {
    for (io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMetaBuilder item: relatedResources) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingRelatedResource(java.util.function.Predicate<io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMetaBuilder> predicate) {
    for (io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMetaBuilder item: relatedResources) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRelatedResources(java.util.List<io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMeta> relatedResources) {
    if (this.relatedResources != null) { _visitables.get("relatedResources").removeAll(this.relatedResources);}
    if (relatedResources != null) {this.relatedResources = new java.util.ArrayList(); for (io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMeta item : relatedResources){this.addToRelatedResources(item);}} else { this.relatedResources = null;} return (A) this;
  }
  public A withRelatedResources(io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMeta... relatedResources) {
    if (this.relatedResources != null) {this.relatedResources.clear();}
    if (relatedResources != null) {for (io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMeta item :relatedResources){ this.addToRelatedResources(item);}} return (A) this;
  }
  public java.lang.Boolean hasRelatedResources() {
    return relatedResources != null && !relatedResources.isEmpty();
  }
  public A addNewRelatedResource(java.lang.String group,java.lang.String name,java.lang.String namespace,java.lang.String resource,java.lang.String version) {
    return (A)addToRelatedResources(new RelatedResourceMeta(group, name, namespace, resource, version));
  }
  public io.fabric8.openclustermanagement.api.model.operator.v1.ClusterManagerStatusFluent.RelatedResourcesNested<A> addNewRelatedResource() {
    return new io.fabric8.openclustermanagement.api.model.operator.v1.ClusterManagerStatusFluentImpl.RelatedResourcesNestedImpl();
  }
  public io.fabric8.openclustermanagement.api.model.operator.v1.ClusterManagerStatusFluent.RelatedResourcesNested<A> addNewRelatedResourceLike(io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMeta item) {
    return new io.fabric8.openclustermanagement.api.model.operator.v1.ClusterManagerStatusFluentImpl.RelatedResourcesNestedImpl(-1, item);
  }
  public io.fabric8.openclustermanagement.api.model.operator.v1.ClusterManagerStatusFluent.RelatedResourcesNested<A> setNewRelatedResourceLike(java.lang.Integer index,io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMeta item) {
    return new io.fabric8.openclustermanagement.api.model.operator.v1.ClusterManagerStatusFluentImpl.RelatedResourcesNestedImpl(index, item);
  }
  public io.fabric8.openclustermanagement.api.model.operator.v1.ClusterManagerStatusFluent.RelatedResourcesNested<A> editRelatedResource(java.lang.Integer index) {
    if (relatedResources.size() <= index) throw new RuntimeException("Can't edit relatedResources. Index exceeds size.");
    return setNewRelatedResourceLike(index, buildRelatedResource(index));
  }
  public io.fabric8.openclustermanagement.api.model.operator.v1.ClusterManagerStatusFluent.RelatedResourcesNested<A> editFirstRelatedResource() {
    if (relatedResources.size() == 0) throw new RuntimeException("Can't edit first relatedResources. The list is empty.");
    return setNewRelatedResourceLike(0, buildRelatedResource(0));
  }
  public io.fabric8.openclustermanagement.api.model.operator.v1.ClusterManagerStatusFluent.RelatedResourcesNested<A> editLastRelatedResource() {
    int index = relatedResources.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last relatedResources. The list is empty.");
    return setNewRelatedResourceLike(index, buildRelatedResource(index));
  }
  public io.fabric8.openclustermanagement.api.model.operator.v1.ClusterManagerStatusFluent.RelatedResourcesNested<A> editMatchingRelatedResource(java.util.function.Predicate<io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMetaBuilder> predicate) {
    int index = -1;
    for (int i=0;i<relatedResources.size();i++) { 
    if (predicate.test(relatedResources.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching relatedResources. No match found.");
    return setNewRelatedResourceLike(index, buildRelatedResource(index));
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ClusterManagerStatusFluentImpl that = (ClusterManagerStatusFluentImpl) o;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (generations != null ? !generations.equals(that.generations) :that.generations != null) return false;
    if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
    if (relatedResources != null ? !relatedResources.equals(that.relatedResources) :that.relatedResources != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(conditions,  generations,  observedGeneration,  relatedResources,  super.hashCode());
  }
  public class GenerationsNestedImpl<N> extends io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatusFluentImpl<io.fabric8.openclustermanagement.api.model.operator.v1.ClusterManagerStatusFluent.GenerationsNested<N>> implements io.fabric8.openclustermanagement.api.model.operator.v1.ClusterManagerStatusFluent.GenerationsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    GenerationsNestedImpl(java.lang.Integer index,io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatus item) {
      this.index = index;
      this.builder = new io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatusBuilder(this, item);
    }
    GenerationsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatusBuilder(this);
    }
    io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatusBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) ClusterManagerStatusFluentImpl.this.setToGenerations(index,builder.build());
    }
    public N endGeneration() {
      return and();
    }
    
  }
  public class RelatedResourcesNestedImpl<N> extends io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMetaFluentImpl<io.fabric8.openclustermanagement.api.model.operator.v1.ClusterManagerStatusFluent.RelatedResourcesNested<N>> implements io.fabric8.openclustermanagement.api.model.operator.v1.ClusterManagerStatusFluent.RelatedResourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RelatedResourcesNestedImpl(java.lang.Integer index,io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMeta item) {
      this.index = index;
      this.builder = new io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMetaBuilder(this, item);
    }
    RelatedResourcesNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMetaBuilder(this);
    }
    io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMetaBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) ClusterManagerStatusFluentImpl.this.setToRelatedResources(index,builder.build());
    }
    public N endRelatedResource() {
      return and();
    }
    
  }
  
}