package io.fabric8.openclustermanagement.api.model.multiclusterobservabilityoperator.shared;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ObservabilityAddonSpecBuilder extends ObservabilityAddonSpecFluent<ObservabilityAddonSpecBuilder> implements VisitableBuilder<ObservabilityAddonSpec,ObservabilityAddonSpecBuilder>{
  public ObservabilityAddonSpecBuilder() {
    this(new ObservabilityAddonSpec());
  }
  
  public ObservabilityAddonSpecBuilder(ObservabilityAddonSpecFluent<?> fluent) {
    this(fluent, new ObservabilityAddonSpec());
  }
  
  public ObservabilityAddonSpecBuilder(ObservabilityAddonSpecFluent<?> fluent,ObservabilityAddonSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ObservabilityAddonSpecBuilder(ObservabilityAddonSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ObservabilityAddonSpecFluent<?> fluent;
  
  public ObservabilityAddonSpec build() {
    ObservabilityAddonSpec buildable = new ObservabilityAddonSpec(fluent.getEnableMetrics(),fluent.getInterval(),fluent.buildResources());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}