package io.fabric8.openclustermanagement.api.model.multiclusterobservabilityoperator.apps.v1beta2;

import io.fabric8.openclustermanagement.api.model.multiclusterobservabilityoperator.shared.PreConfiguredStorage;
import io.fabric8.openclustermanagement.api.model.multiclusterobservabilityoperator.shared.PreConfiguredStorageBuilder;
import io.fabric8.openclustermanagement.api.model.multiclusterobservabilityoperator.shared.PreConfiguredStorageFluent;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Object;
import java.lang.String;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class StorageConfigFluent<A extends StorageConfigFluent<A>> extends BaseFluent<A>{
  public StorageConfigFluent() {
  }
  public StorageConfigFluent(StorageConfig instance) {
    instance = (instance != null ? instance : new StorageConfig());

    if (instance != null) {
      this.withAlertmanagerStorageSize(instance.getAlertmanagerStorageSize());
      this.withCompactStorageSize(instance.getCompactStorageSize());
      this.withMetricObjectStorage(instance.getMetricObjectStorage());
      this.withReceiveStorageSize(instance.getReceiveStorageSize());
      this.withRuleStorageSize(instance.getRuleStorageSize());
      this.withStorageClass(instance.getStorageClass());
      this.withStoreStorageSize(instance.getStoreStorageSize());
      this.withAlertmanagerStorageSize(instance.getAlertmanagerStorageSize());
      this.withCompactStorageSize(instance.getCompactStorageSize());
      this.withMetricObjectStorage(instance.getMetricObjectStorage());
      this.withReceiveStorageSize(instance.getReceiveStorageSize());
      this.withRuleStorageSize(instance.getRuleStorageSize());
      this.withStorageClass(instance.getStorageClass());
      this.withStoreStorageSize(instance.getStoreStorageSize());
    }
  }
  private String alertmanagerStorageSize;
  private String compactStorageSize;
  private PreConfiguredStorageBuilder metricObjectStorage;
  private String receiveStorageSize;
  private String ruleStorageSize;
  private String storageClass;
  private String storeStorageSize;
  public String getAlertmanagerStorageSize() {
    return this.alertmanagerStorageSize;
  }
  public A withAlertmanagerStorageSize(String alertmanagerStorageSize) {
    this.alertmanagerStorageSize=alertmanagerStorageSize; return (A) this;
  }
  public boolean hasAlertmanagerStorageSize() {
    return this.alertmanagerStorageSize != null;
  }
  public String getCompactStorageSize() {
    return this.compactStorageSize;
  }
  public A withCompactStorageSize(String compactStorageSize) {
    this.compactStorageSize=compactStorageSize; return (A) this;
  }
  public boolean hasCompactStorageSize() {
    return this.compactStorageSize != null;
  }
  public PreConfiguredStorage buildMetricObjectStorage() {
    return this.metricObjectStorage!=null ?this.metricObjectStorage.build():null;
  }
  public A withMetricObjectStorage(PreConfiguredStorage metricObjectStorage) {
    _visitables.get("metricObjectStorage").remove(this.metricObjectStorage);
    if (metricObjectStorage!=null){ this.metricObjectStorage= new PreConfiguredStorageBuilder(metricObjectStorage); _visitables.get("metricObjectStorage").add(this.metricObjectStorage);} else { this.metricObjectStorage = null; _visitables.get("metricObjectStorage").remove(this.metricObjectStorage); } return (A) this;
  }
  public boolean hasMetricObjectStorage() {
    return this.metricObjectStorage != null;
  }
  public A withNewMetricObjectStorage(String key,String name) {
    return (A)withMetricObjectStorage(new PreConfiguredStorage(key, name));
  }
  public MetricObjectStorageNested<A> withNewMetricObjectStorage() {
    return new MetricObjectStorageNested(null);
  }
  public MetricObjectStorageNested<A> withNewMetricObjectStorageLike(PreConfiguredStorage item) {
    return new MetricObjectStorageNested(item);
  }
  public MetricObjectStorageNested<A> editMetricObjectStorage() {
    return withNewMetricObjectStorageLike(java.util.Optional.ofNullable(buildMetricObjectStorage()).orElse(null));
  }
  public MetricObjectStorageNested<A> editOrNewMetricObjectStorage() {
    return withNewMetricObjectStorageLike(java.util.Optional.ofNullable(buildMetricObjectStorage()).orElse(new PreConfiguredStorageBuilder().build()));
  }
  public MetricObjectStorageNested<A> editOrNewMetricObjectStorageLike(PreConfiguredStorage item) {
    return withNewMetricObjectStorageLike(java.util.Optional.ofNullable(buildMetricObjectStorage()).orElse(item));
  }
  public String getReceiveStorageSize() {
    return this.receiveStorageSize;
  }
  public A withReceiveStorageSize(String receiveStorageSize) {
    this.receiveStorageSize=receiveStorageSize; return (A) this;
  }
  public boolean hasReceiveStorageSize() {
    return this.receiveStorageSize != null;
  }
  public String getRuleStorageSize() {
    return this.ruleStorageSize;
  }
  public A withRuleStorageSize(String ruleStorageSize) {
    this.ruleStorageSize=ruleStorageSize; return (A) this;
  }
  public boolean hasRuleStorageSize() {
    return this.ruleStorageSize != null;
  }
  public String getStorageClass() {
    return this.storageClass;
  }
  public A withStorageClass(String storageClass) {
    this.storageClass=storageClass; return (A) this;
  }
  public boolean hasStorageClass() {
    return this.storageClass != null;
  }
  public String getStoreStorageSize() {
    return this.storeStorageSize;
  }
  public A withStoreStorageSize(String storeStorageSize) {
    this.storeStorageSize=storeStorageSize; return (A) this;
  }
  public boolean hasStoreStorageSize() {
    return this.storeStorageSize != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    StorageConfigFluent that = (StorageConfigFluent) o;
    if (!java.util.Objects.equals(alertmanagerStorageSize, that.alertmanagerStorageSize)) return false;

    if (!java.util.Objects.equals(compactStorageSize, that.compactStorageSize)) return false;

    if (!java.util.Objects.equals(metricObjectStorage, that.metricObjectStorage)) return false;

    if (!java.util.Objects.equals(receiveStorageSize, that.receiveStorageSize)) return false;

    if (!java.util.Objects.equals(ruleStorageSize, that.ruleStorageSize)) return false;

    if (!java.util.Objects.equals(storageClass, that.storageClass)) return false;

    if (!java.util.Objects.equals(storeStorageSize, that.storeStorageSize)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(alertmanagerStorageSize,  compactStorageSize,  metricObjectStorage,  receiveStorageSize,  ruleStorageSize,  storageClass,  storeStorageSize,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (alertmanagerStorageSize != null) { sb.append("alertmanagerStorageSize:"); sb.append(alertmanagerStorageSize + ","); }
    if (compactStorageSize != null) { sb.append("compactStorageSize:"); sb.append(compactStorageSize + ","); }
    if (metricObjectStorage != null) { sb.append("metricObjectStorage:"); sb.append(metricObjectStorage + ","); }
    if (receiveStorageSize != null) { sb.append("receiveStorageSize:"); sb.append(receiveStorageSize + ","); }
    if (ruleStorageSize != null) { sb.append("ruleStorageSize:"); sb.append(ruleStorageSize + ","); }
    if (storageClass != null) { sb.append("storageClass:"); sb.append(storageClass + ","); }
    if (storeStorageSize != null) { sb.append("storeStorageSize:"); sb.append(storeStorageSize); }
    sb.append("}");
    return sb.toString();
  }
  public class MetricObjectStorageNested<N> extends PreConfiguredStorageFluent<MetricObjectStorageNested<N>> implements Nested<N>{
    MetricObjectStorageNested(PreConfiguredStorage item) {
      this.builder = new PreConfiguredStorageBuilder(this, item);
    }
    PreConfiguredStorageBuilder builder;
    public N and() {
      return (N) StorageConfigFluent.this.withMetricObjectStorage(builder.build());
    }
    public N endMetricObjectStorage() {
      return and();
    }
    
  }
  
}