package io.fabric8.openclustermanagement.api.model.multiclusterobservabilityoperator.apps.v1beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CompactSpecBuilder extends CompactSpecFluent<CompactSpecBuilder> implements VisitableBuilder<CompactSpec,CompactSpecBuilder>{
  public CompactSpecBuilder() {
    this(false);
  }
  public CompactSpecBuilder(Boolean validationEnabled) {
    this(new CompactSpec(), validationEnabled);
  }
  public CompactSpecBuilder(CompactSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public CompactSpecBuilder(CompactSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CompactSpec(), validationEnabled);
  }
  public CompactSpecBuilder(CompactSpecFluent<?> fluent,CompactSpec instance) {
    this(fluent, instance, false);
  }
  public CompactSpecBuilder(CompactSpecFluent<?> fluent,CompactSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CompactSpec());

    if (instance != null) {
      fluent.withResources(instance.getResources());
      fluent.withResources(instance.getResources());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CompactSpecBuilder(CompactSpec instance) {
    this(instance,false);
  }
  public CompactSpecBuilder(CompactSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CompactSpec());

    if (instance != null) {
      this.withResources(instance.getResources());
      this.withResources(instance.getResources());
    }
    this.validationEnabled = validationEnabled; 
  }
  CompactSpecFluent<?> fluent;
  Boolean validationEnabled;
  public CompactSpec build() {
    CompactSpec buildable = new CompactSpec(fluent.buildResources());
    return buildable;
  }
  
}