package io.fabric8.openclustermanagement.api.model.multiclusterobservabilityoperator.apps.v1beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CommonSpecBuilder extends CommonSpecFluent<CommonSpecBuilder> implements VisitableBuilder<CommonSpec,CommonSpecBuilder>{
  public CommonSpecBuilder() {
    this(false);
  }
  public CommonSpecBuilder(Boolean validationEnabled) {
    this(new CommonSpec(), validationEnabled);
  }
  public CommonSpecBuilder(CommonSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public CommonSpecBuilder(CommonSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CommonSpec(), validationEnabled);
  }
  public CommonSpecBuilder(CommonSpecFluent<?> fluent,CommonSpec instance) {
    this(fluent, instance, false);
  }
  public CommonSpecBuilder(CommonSpecFluent<?> fluent,CommonSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CommonSpec());

    if (instance != null) {
      fluent.withReplicas(instance.getReplicas());
      fluent.withResources(instance.getResources());
      fluent.withReplicas(instance.getReplicas());
      fluent.withResources(instance.getResources());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CommonSpecBuilder(CommonSpec instance) {
    this(instance,false);
  }
  public CommonSpecBuilder(CommonSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CommonSpec());

    if (instance != null) {
      this.withReplicas(instance.getReplicas());
      this.withResources(instance.getResources());
      this.withReplicas(instance.getReplicas());
      this.withResources(instance.getResources());
    }
    this.validationEnabled = validationEnabled; 
  }
  CommonSpecFluent<?> fluent;
  Boolean validationEnabled;
  public CommonSpec build() {
    CommonSpec buildable = new CommonSpec(fluent.getReplicas(),fluent.buildResources());
    return buildable;
  }
  
}