package io.fabric8.openclustermanagement.api.model.multiclusterobservabilityoperator.apps.v1beta2;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CacheConfigFluent<A extends CacheConfigFluent<A>> extends BaseFluent<A>{
  public CacheConfigFluent() {
  }
  public CacheConfigFluent(CacheConfig instance) {
    instance = (instance != null ? instance : new CacheConfig());

    if (instance != null) {
      this.withConnectionLimit(instance.getConnectionLimit());
      this.withMaxItemSize(instance.getMaxItemSize());
      this.withMemoryLimitMb(instance.getMemoryLimitMb());
      this.withReplicas(instance.getReplicas());
      this.withResources(instance.getResources());
      this.withConnectionLimit(instance.getConnectionLimit());
      this.withMaxItemSize(instance.getMaxItemSize());
      this.withMemoryLimitMb(instance.getMemoryLimitMb());
      this.withReplicas(instance.getReplicas());
      this.withResources(instance.getResources());
    }
  }
  private Integer connectionLimit;
  private String maxItemSize;
  private Integer memoryLimitMb;
  private Integer replicas;
  private ResourceRequirementsBuilder resources;
  public Integer getConnectionLimit() {
    return this.connectionLimit;
  }
  public A withConnectionLimit(Integer connectionLimit) {
    this.connectionLimit=connectionLimit; return (A) this;
  }
  public boolean hasConnectionLimit() {
    return this.connectionLimit != null;
  }
  public String getMaxItemSize() {
    return this.maxItemSize;
  }
  public A withMaxItemSize(String maxItemSize) {
    this.maxItemSize=maxItemSize; return (A) this;
  }
  public boolean hasMaxItemSize() {
    return this.maxItemSize != null;
  }
  public Integer getMemoryLimitMb() {
    return this.memoryLimitMb;
  }
  public A withMemoryLimitMb(Integer memoryLimitMb) {
    this.memoryLimitMb=memoryLimitMb; return (A) this;
  }
  public boolean hasMemoryLimitMb() {
    return this.memoryLimitMb != null;
  }
  public Integer getReplicas() {
    return this.replicas;
  }
  public A withReplicas(Integer replicas) {
    this.replicas=replicas; return (A) this;
  }
  public boolean hasReplicas() {
    return this.replicas != null;
  }
  public ResourceRequirements buildResources() {
    return this.resources!=null ?this.resources.build():null;
  }
  public A withResources(ResourceRequirements resources) {
    _visitables.get("resources").remove(this.resources);
    if (resources!=null){ this.resources= new ResourceRequirementsBuilder(resources); _visitables.get("resources").add(this.resources);} else { this.resources = null; _visitables.get("resources").remove(this.resources); } return (A) this;
  }
  public boolean hasResources() {
    return this.resources != null;
  }
  public ResourcesNested<A> withNewResources() {
    return new ResourcesNested(null);
  }
  public ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
    return new ResourcesNested(item);
  }
  public ResourcesNested<A> editResources() {
    return withNewResourcesLike(java.util.Optional.ofNullable(buildResources()).orElse(null));
  }
  public ResourcesNested<A> editOrNewResources() {
    return withNewResourcesLike(java.util.Optional.ofNullable(buildResources()).orElse(new ResourceRequirementsBuilder().build()));
  }
  public ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
    return withNewResourcesLike(java.util.Optional.ofNullable(buildResources()).orElse(item));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CacheConfigFluent that = (CacheConfigFluent) o;
    if (!java.util.Objects.equals(connectionLimit, that.connectionLimit)) return false;

    if (!java.util.Objects.equals(maxItemSize, that.maxItemSize)) return false;

    if (!java.util.Objects.equals(memoryLimitMb, that.memoryLimitMb)) return false;

    if (!java.util.Objects.equals(replicas, that.replicas)) return false;

    if (!java.util.Objects.equals(resources, that.resources)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(connectionLimit,  maxItemSize,  memoryLimitMb,  replicas,  resources,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (connectionLimit != null) { sb.append("connectionLimit:"); sb.append(connectionLimit + ","); }
    if (maxItemSize != null) { sb.append("maxItemSize:"); sb.append(maxItemSize + ","); }
    if (memoryLimitMb != null) { sb.append("memoryLimitMb:"); sb.append(memoryLimitMb + ","); }
    if (replicas != null) { sb.append("replicas:"); sb.append(replicas + ","); }
    if (resources != null) { sb.append("resources:"); sb.append(resources); }
    sb.append("}");
    return sb.toString();
  }
  public class ResourcesNested<N> extends ResourceRequirementsFluent<ResourcesNested<N>> implements Nested<N>{
    ResourcesNested(ResourceRequirements item) {
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ResourceRequirementsBuilder builder;
    public N and() {
      return (N) CacheConfigFluent.this.withResources(builder.build());
    }
    public N endResources() {
      return and();
    }
    
  }
  
}