package io.fabric8.openclustermanagement.api.model.multiclusterobservabilityoperator.apps.v1beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CacheConfigBuilder extends CacheConfigFluent<CacheConfigBuilder> implements VisitableBuilder<CacheConfig,CacheConfigBuilder>{
  public CacheConfigBuilder() {
    this(false);
  }
  public CacheConfigBuilder(Boolean validationEnabled) {
    this(new CacheConfig(), validationEnabled);
  }
  public CacheConfigBuilder(CacheConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public CacheConfigBuilder(CacheConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CacheConfig(), validationEnabled);
  }
  public CacheConfigBuilder(CacheConfigFluent<?> fluent,CacheConfig instance) {
    this(fluent, instance, false);
  }
  public CacheConfigBuilder(CacheConfigFluent<?> fluent,CacheConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CacheConfig());

    if (instance != null) {
      fluent.withConnectionLimit(instance.getConnectionLimit());
      fluent.withMaxItemSize(instance.getMaxItemSize());
      fluent.withMemoryLimitMb(instance.getMemoryLimitMb());
      fluent.withReplicas(instance.getReplicas());
      fluent.withResources(instance.getResources());
      fluent.withConnectionLimit(instance.getConnectionLimit());
      fluent.withMaxItemSize(instance.getMaxItemSize());
      fluent.withMemoryLimitMb(instance.getMemoryLimitMb());
      fluent.withReplicas(instance.getReplicas());
      fluent.withResources(instance.getResources());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CacheConfigBuilder(CacheConfig instance) {
    this(instance,false);
  }
  public CacheConfigBuilder(CacheConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CacheConfig());

    if (instance != null) {
      this.withConnectionLimit(instance.getConnectionLimit());
      this.withMaxItemSize(instance.getMaxItemSize());
      this.withMemoryLimitMb(instance.getMemoryLimitMb());
      this.withReplicas(instance.getReplicas());
      this.withResources(instance.getResources());
      this.withConnectionLimit(instance.getConnectionLimit());
      this.withMaxItemSize(instance.getMaxItemSize());
      this.withMemoryLimitMb(instance.getMemoryLimitMb());
      this.withReplicas(instance.getReplicas());
      this.withResources(instance.getResources());
    }
    this.validationEnabled = validationEnabled; 
  }
  CacheConfigFluent<?> fluent;
  Boolean validationEnabled;
  public CacheConfig build() {
    CacheConfig buildable = new CacheConfig(fluent.getConnectionLimit(),fluent.getMaxItemSize(),fluent.getMemoryLimitMb(),fluent.getReplicas(),fluent.buildResources());
    return buildable;
  }
  
}