package io.fabric8.openclustermanagement.api.model.multiclusterobservabilityoperator.apps.v1beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AdvancedConfigBuilder extends AdvancedConfigFluent<AdvancedConfigBuilder> implements VisitableBuilder<AdvancedConfig,AdvancedConfigBuilder>{
  public AdvancedConfigBuilder() {
    this(false);
  }
  public AdvancedConfigBuilder(Boolean validationEnabled) {
    this(new AdvancedConfig(), validationEnabled);
  }
  public AdvancedConfigBuilder(AdvancedConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public AdvancedConfigBuilder(AdvancedConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AdvancedConfig(), validationEnabled);
  }
  public AdvancedConfigBuilder(AdvancedConfigFluent<?> fluent,AdvancedConfig instance) {
    this(fluent, instance, false);
  }
  public AdvancedConfigBuilder(AdvancedConfigFluent<?> fluent,AdvancedConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new AdvancedConfig());

    if (instance != null) {
      fluent.withAlertmanager(instance.getAlertmanager());
      fluent.withCompact(instance.getCompact());
      fluent.withGrafana(instance.getGrafana());
      fluent.withObservatoriumAPI(instance.getObservatoriumAPI());
      fluent.withObservatoriumConfig(instance.getObservatoriumConfig());
      fluent.withQuery(instance.getQuery());
      fluent.withQueryFrontend(instance.getQueryFrontend());
      fluent.withQueryFrontendMemcached(instance.getQueryFrontendMemcached());
      fluent.withRbacQueryProxy(instance.getRbacQueryProxy());
      fluent.withReceive(instance.getReceive());
      fluent.withRetentionConfig(instance.getRetentionConfig());
      fluent.withRule(instance.getRule());
      fluent.withStore(instance.getStore());
      fluent.withStoreMemcached(instance.getStoreMemcached());
      fluent.withAlertmanager(instance.getAlertmanager());
      fluent.withCompact(instance.getCompact());
      fluent.withGrafana(instance.getGrafana());
      fluent.withObservatoriumAPI(instance.getObservatoriumAPI());
      fluent.withObservatoriumConfig(instance.getObservatoriumConfig());
      fluent.withQuery(instance.getQuery());
      fluent.withQueryFrontend(instance.getQueryFrontend());
      fluent.withQueryFrontendMemcached(instance.getQueryFrontendMemcached());
      fluent.withRbacQueryProxy(instance.getRbacQueryProxy());
      fluent.withReceive(instance.getReceive());
      fluent.withRetentionConfig(instance.getRetentionConfig());
      fluent.withRule(instance.getRule());
      fluent.withStore(instance.getStore());
      fluent.withStoreMemcached(instance.getStoreMemcached());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AdvancedConfigBuilder(AdvancedConfig instance) {
    this(instance,false);
  }
  public AdvancedConfigBuilder(AdvancedConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new AdvancedConfig());

    if (instance != null) {
      this.withAlertmanager(instance.getAlertmanager());
      this.withCompact(instance.getCompact());
      this.withGrafana(instance.getGrafana());
      this.withObservatoriumAPI(instance.getObservatoriumAPI());
      this.withObservatoriumConfig(instance.getObservatoriumConfig());
      this.withQuery(instance.getQuery());
      this.withQueryFrontend(instance.getQueryFrontend());
      this.withQueryFrontendMemcached(instance.getQueryFrontendMemcached());
      this.withRbacQueryProxy(instance.getRbacQueryProxy());
      this.withReceive(instance.getReceive());
      this.withRetentionConfig(instance.getRetentionConfig());
      this.withRule(instance.getRule());
      this.withStore(instance.getStore());
      this.withStoreMemcached(instance.getStoreMemcached());
      this.withAlertmanager(instance.getAlertmanager());
      this.withCompact(instance.getCompact());
      this.withGrafana(instance.getGrafana());
      this.withObservatoriumAPI(instance.getObservatoriumAPI());
      this.withObservatoriumConfig(instance.getObservatoriumConfig());
      this.withQuery(instance.getQuery());
      this.withQueryFrontend(instance.getQueryFrontend());
      this.withQueryFrontendMemcached(instance.getQueryFrontendMemcached());
      this.withRbacQueryProxy(instance.getRbacQueryProxy());
      this.withReceive(instance.getReceive());
      this.withRetentionConfig(instance.getRetentionConfig());
      this.withRule(instance.getRule());
      this.withStore(instance.getStore());
      this.withStoreMemcached(instance.getStoreMemcached());
    }
    this.validationEnabled = validationEnabled; 
  }
  AdvancedConfigFluent<?> fluent;
  Boolean validationEnabled;
  public AdvancedConfig build() {
    AdvancedConfig buildable = new AdvancedConfig(fluent.buildAlertmanager(),fluent.buildCompact(),fluent.buildGrafana(),fluent.buildObservatoriumAPI(),fluent.buildObservatoriumConfig(),fluent.buildQuery(),fluent.buildQueryFrontend(),fluent.buildQueryFrontendMemcached(),fluent.buildRbacQueryProxy(),fluent.buildReceive(),fluent.buildRetentionConfig(),fluent.buildRule(),fluent.buildStore(),fluent.buildStoreMemcached());
    return buildable;
  }
  
}