package io.fabric8.openclustermanagement.api.model.multiclusterobservabilityoperator.shared;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ObservabilityAddonSpecBuilder extends ObservabilityAddonSpecFluent<ObservabilityAddonSpecBuilder> implements VisitableBuilder<ObservabilityAddonSpec,ObservabilityAddonSpecBuilder>{
  public ObservabilityAddonSpecBuilder() {
    this(false);
  }
  public ObservabilityAddonSpecBuilder(Boolean validationEnabled) {
    this(new ObservabilityAddonSpec(), validationEnabled);
  }
  public ObservabilityAddonSpecBuilder(ObservabilityAddonSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ObservabilityAddonSpecBuilder(ObservabilityAddonSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ObservabilityAddonSpec(), validationEnabled);
  }
  public ObservabilityAddonSpecBuilder(ObservabilityAddonSpecFluent<?> fluent,ObservabilityAddonSpec instance) {
    this(fluent, instance, false);
  }
  public ObservabilityAddonSpecBuilder(ObservabilityAddonSpecFluent<?> fluent,ObservabilityAddonSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ObservabilityAddonSpec());

    if (instance != null) {
      fluent.withEnableMetrics(instance.getEnableMetrics());
      fluent.withInterval(instance.getInterval());
      fluent.withResources(instance.getResources());
      fluent.withEnableMetrics(instance.getEnableMetrics());
      fluent.withInterval(instance.getInterval());
      fluent.withResources(instance.getResources());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ObservabilityAddonSpecBuilder(ObservabilityAddonSpec instance) {
    this(instance,false);
  }
  public ObservabilityAddonSpecBuilder(ObservabilityAddonSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ObservabilityAddonSpec());

    if (instance != null) {
      this.withEnableMetrics(instance.getEnableMetrics());
      this.withInterval(instance.getInterval());
      this.withResources(instance.getResources());
      this.withEnableMetrics(instance.getEnableMetrics());
      this.withInterval(instance.getInterval());
      this.withResources(instance.getResources());
    }
    this.validationEnabled = validationEnabled; 
  }
  ObservabilityAddonSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ObservabilityAddonSpec build() {
    ObservabilityAddonSpec buildable = new ObservabilityAddonSpec(fluent.getEnableMetrics(),fluent.getInterval(),fluent.buildResources());
    return buildable;
  }
  
}