package io.fabric8.openclustermanagement.api.model.multiclusterobservabilityoperator.apps.v1beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MultiClusterObservabilityBuilder extends MultiClusterObservabilityFluent<MultiClusterObservabilityBuilder> implements VisitableBuilder<MultiClusterObservability,MultiClusterObservabilityBuilder>{
  public MultiClusterObservabilityBuilder() {
    this(false);
  }
  public MultiClusterObservabilityBuilder(Boolean validationEnabled) {
    this(new MultiClusterObservability(), validationEnabled);
  }
  public MultiClusterObservabilityBuilder(MultiClusterObservabilityFluent<?> fluent) {
    this(fluent, false);
  }
  public MultiClusterObservabilityBuilder(MultiClusterObservabilityFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MultiClusterObservability(), validationEnabled);
  }
  public MultiClusterObservabilityBuilder(MultiClusterObservabilityFluent<?> fluent,MultiClusterObservability instance) {
    this(fluent, instance, false);
  }
  public MultiClusterObservabilityBuilder(MultiClusterObservabilityFluent<?> fluent,MultiClusterObservability instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new MultiClusterObservability());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MultiClusterObservabilityBuilder(MultiClusterObservability instance) {
    this(instance,false);
  }
  public MultiClusterObservabilityBuilder(MultiClusterObservability instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new MultiClusterObservability());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  MultiClusterObservabilityFluent<?> fluent;
  Boolean validationEnabled;
  public MultiClusterObservability build() {
    MultiClusterObservability buildable = new MultiClusterObservability(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  
}