package io.fabric8.openclustermanagement.api.model.multiclusterobservabilityoperator.apps.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StatusConditionBuilder extends StatusConditionFluent<StatusConditionBuilder> implements VisitableBuilder<StatusCondition,StatusConditionBuilder>{
  public StatusConditionBuilder() {
    this(false);
  }
  public StatusConditionBuilder(Boolean validationEnabled) {
    this(new StatusCondition(), validationEnabled);
  }
  public StatusConditionBuilder(StatusConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public StatusConditionBuilder(StatusConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StatusCondition(), validationEnabled);
  }
  public StatusConditionBuilder(StatusConditionFluent<?> fluent,StatusCondition instance) {
    this(fluent, instance, false);
  }
  public StatusConditionBuilder(StatusConditionFluent<?> fluent,StatusCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new StatusCondition());

    if (instance != null) {
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  public StatusConditionBuilder(StatusCondition instance) {
    this(instance,false);
  }
  public StatusConditionBuilder(StatusCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new StatusCondition());

    if (instance != null) {
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  StatusConditionFluent<?> fluent;
  Boolean validationEnabled;
  public StatusCondition build() {
    StatusCondition buildable = new StatusCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    return buildable;
  }
  
}