package io.fabric8.openclustermanagement.api.model.multiclusterobservabilityoperator.shared;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PreConfiguredStorageBuilder extends PreConfiguredStorageFluentImpl<PreConfiguredStorageBuilder> implements VisitableBuilder<PreConfiguredStorage,PreConfiguredStorageBuilder>{
  public PreConfiguredStorageBuilder() {
    this(false);
  }
  public PreConfiguredStorageBuilder(Boolean validationEnabled) {
    this(new PreConfiguredStorage(), validationEnabled);
  }
  public PreConfiguredStorageBuilder(PreConfiguredStorageFluent<?> fluent) {
    this(fluent, false);
  }
  public PreConfiguredStorageBuilder(PreConfiguredStorageFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PreConfiguredStorage(), validationEnabled);
  }
  public PreConfiguredStorageBuilder(PreConfiguredStorageFluent<?> fluent,PreConfiguredStorage instance) {
    this(fluent, instance, false);
  }
  public PreConfiguredStorageBuilder(PreConfiguredStorageFluent<?> fluent,PreConfiguredStorage instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withKey(instance.getKey());
      fluent.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PreConfiguredStorageBuilder(PreConfiguredStorage instance) {
    this(instance,false);
  }
  public PreConfiguredStorageBuilder(PreConfiguredStorage instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withKey(instance.getKey());
      this.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  PreConfiguredStorageFluent<?> fluent;
  Boolean validationEnabled;
  public PreConfiguredStorage build() {
    PreConfiguredStorage buildable = new PreConfiguredStorage(fluent.getKey(),fluent.getName());
    return buildable;
  }
  
}