package io.fabric8.openclustermanagement.api.model.multiclusterobservabilityoperator.apps.v1beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MultiClusterObservabilityListBuilder extends MultiClusterObservabilityListFluentImpl<MultiClusterObservabilityListBuilder> implements VisitableBuilder<MultiClusterObservabilityList,MultiClusterObservabilityListBuilder>{
  public MultiClusterObservabilityListBuilder() {
    this(false);
  }
  public MultiClusterObservabilityListBuilder(Boolean validationEnabled) {
    this(new MultiClusterObservabilityList(), validationEnabled);
  }
  public MultiClusterObservabilityListBuilder(MultiClusterObservabilityListFluent<?> fluent) {
    this(fluent, false);
  }
  public MultiClusterObservabilityListBuilder(MultiClusterObservabilityListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MultiClusterObservabilityList(), validationEnabled);
  }
  public MultiClusterObservabilityListBuilder(MultiClusterObservabilityListFluent<?> fluent,MultiClusterObservabilityList instance) {
    this(fluent, instance, false);
  }
  public MultiClusterObservabilityListBuilder(MultiClusterObservabilityListFluent<?> fluent,MultiClusterObservabilityList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MultiClusterObservabilityListBuilder(MultiClusterObservabilityList instance) {
    this(instance,false);
  }
  public MultiClusterObservabilityListBuilder(MultiClusterObservabilityList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  MultiClusterObservabilityListFluent<?> fluent;
  Boolean validationEnabled;
  public MultiClusterObservabilityList build() {
    MultiClusterObservabilityList buildable = new MultiClusterObservabilityList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}