package io.fabric8.openclustermanagement.api.model.multiclusterobservabilityoperator.apps.v1beta2;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CacheConfigFluentImpl<A extends CacheConfigFluent<A>> extends BaseFluent<A> implements CacheConfigFluent<A>{
  public CacheConfigFluentImpl() {
  }
  public CacheConfigFluentImpl(CacheConfig instance) {
    if (instance != null) {
      this.withConnectionLimit(instance.getConnectionLimit());
      this.withMaxItemSize(instance.getMaxItemSize());
      this.withMemoryLimitMb(instance.getMemoryLimitMb());
      this.withReplicas(instance.getReplicas());
      this.withResources(instance.getResources());
    }
  }
  private Integer connectionLimit;
  private String maxItemSize;
  private Integer memoryLimitMb;
  private Integer replicas;
  private ResourceRequirementsBuilder resources;
  public Integer getConnectionLimit() {
    return this.connectionLimit;
  }
  public A withConnectionLimit(Integer connectionLimit) {
    this.connectionLimit=connectionLimit; return (A) this;
  }
  public Boolean hasConnectionLimit() {
    return this.connectionLimit != null;
  }
  public String getMaxItemSize() {
    return this.maxItemSize;
  }
  public A withMaxItemSize(String maxItemSize) {
    this.maxItemSize=maxItemSize; return (A) this;
  }
  public Boolean hasMaxItemSize() {
    return this.maxItemSize != null;
  }
  public Integer getMemoryLimitMb() {
    return this.memoryLimitMb;
  }
  public A withMemoryLimitMb(Integer memoryLimitMb) {
    this.memoryLimitMb=memoryLimitMb; return (A) this;
  }
  public Boolean hasMemoryLimitMb() {
    return this.memoryLimitMb != null;
  }
  public Integer getReplicas() {
    return this.replicas;
  }
  public A withReplicas(Integer replicas) {
    this.replicas=replicas; return (A) this;
  }
  public Boolean hasReplicas() {
    return this.replicas != null;
  }
  
  /**
   * This method has been deprecated, please use method buildResources instead.
   * @return The buildable object.
   */
  @Deprecated
  public ResourceRequirements getResources() {
    return this.resources!=null ?this.resources.build():null;
  }
  public ResourceRequirements buildResources() {
    return this.resources!=null ?this.resources.build():null;
  }
  public A withResources(ResourceRequirements resources) {
    _visitables.get("resources").remove(this.resources);
    if (resources!=null){ this.resources= new ResourceRequirementsBuilder(resources); _visitables.get("resources").add(this.resources);} else { this.resources = null; _visitables.get("resources").remove(this.resources); } return (A) this;
  }
  public Boolean hasResources() {
    return this.resources != null;
  }
  public CacheConfigFluentImpl.ResourcesNested<A> withNewResources() {
    return new CacheConfigFluentImpl.ResourcesNestedImpl();
  }
  public CacheConfigFluentImpl.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
    return new CacheConfigFluentImpl.ResourcesNestedImpl(item);
  }
  public CacheConfigFluentImpl.ResourcesNested<A> editResources() {
    return withNewResourcesLike(getResources());
  }
  public CacheConfigFluentImpl.ResourcesNested<A> editOrNewResources() {
    return withNewResourcesLike(getResources() != null ? getResources(): new ResourceRequirementsBuilder().build());
  }
  public CacheConfigFluentImpl.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
    return withNewResourcesLike(getResources() != null ? getResources(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CacheConfigFluentImpl that = (CacheConfigFluentImpl) o;
    if (!java.util.Objects.equals(connectionLimit, that.connectionLimit)) return false;

    if (!java.util.Objects.equals(maxItemSize, that.maxItemSize)) return false;

    if (!java.util.Objects.equals(memoryLimitMb, that.memoryLimitMb)) return false;

    if (!java.util.Objects.equals(replicas, that.replicas)) return false;

    if (!java.util.Objects.equals(resources, that.resources)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(connectionLimit,  maxItemSize,  memoryLimitMb,  replicas,  resources,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (connectionLimit != null) { sb.append("connectionLimit:"); sb.append(connectionLimit + ","); }
    if (maxItemSize != null) { sb.append("maxItemSize:"); sb.append(maxItemSize + ","); }
    if (memoryLimitMb != null) { sb.append("memoryLimitMb:"); sb.append(memoryLimitMb + ","); }
    if (replicas != null) { sb.append("replicas:"); sb.append(replicas + ","); }
    if (resources != null) { sb.append("resources:"); sb.append(resources); }
    sb.append("}");
    return sb.toString();
  }
  class ResourcesNestedImpl<N> extends ResourceRequirementsFluentImpl<CacheConfigFluentImpl.ResourcesNested<N>> implements CacheConfigFluentImpl.ResourcesNested<N>,Nested<N>{
    ResourcesNestedImpl(ResourceRequirements item) {
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ResourcesNestedImpl() {
      this.builder = new ResourceRequirementsBuilder(this);
    }
    ResourceRequirementsBuilder builder;
    public N and() {
      return (N) CacheConfigFluentImpl.this.withResources(builder.build());
    }
    public N endResources() {
      return and();
    }
    
  }
  
}