/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.multiclusterobservabilityoperator.apps.v1beta2;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;
import io.fabric8.openclustermanagement.api.model.multiclusterobservabilityoperator.apps.v1beta2.CacheConfig;
import io.fabric8.openclustermanagement.api.model.multiclusterobservabilityoperator.apps.v1beta2.CacheConfigFluent;
import java.util.Objects;

public class CacheConfigFluentImpl<A extends CacheConfigFluent<A>>
extends BaseFluent<A>
implements CacheConfigFluent<A> {
    private Integer connectionLimit;
    private String maxItemSize;
    private Integer memoryLimitMb;
    private Integer replicas;
    private ResourceRequirementsBuilder resources;

    public CacheConfigFluentImpl() {
    }

    public CacheConfigFluentImpl(CacheConfig instance) {
        if (instance != null) {
            this.withConnectionLimit(instance.getConnectionLimit());
            this.withMaxItemSize(instance.getMaxItemSize());
            this.withMemoryLimitMb(instance.getMemoryLimitMb());
            this.withReplicas(instance.getReplicas());
            this.withResources(instance.getResources());
        }
    }

    @Override
    public Integer getConnectionLimit() {
        return this.connectionLimit;
    }

    @Override
    public A withConnectionLimit(Integer connectionLimit) {
        this.connectionLimit = connectionLimit;
        return (A)this;
    }

    @Override
    public Boolean hasConnectionLimit() {
        return this.connectionLimit != null;
    }

    @Override
    public String getMaxItemSize() {
        return this.maxItemSize;
    }

    @Override
    public A withMaxItemSize(String maxItemSize) {
        this.maxItemSize = maxItemSize;
        return (A)this;
    }

    @Override
    public Boolean hasMaxItemSize() {
        return this.maxItemSize != null;
    }

    @Override
    public Integer getMemoryLimitMb() {
        return this.memoryLimitMb;
    }

    @Override
    public A withMemoryLimitMb(Integer memoryLimitMb) {
        this.memoryLimitMb = memoryLimitMb;
        return (A)this;
    }

    @Override
    public Boolean hasMemoryLimitMb() {
        return this.memoryLimitMb != null;
    }

    @Override
    public Integer getReplicas() {
        return this.replicas;
    }

    @Override
    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    @Override
    public Boolean hasReplicas() {
        return this.replicas != null;
    }

    @Override
    @Deprecated
    public ResourceRequirements getResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    @Override
    public ResourceRequirements buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    @Override
    public A withResources(ResourceRequirements resources) {
        this._visitables.get((Object)"resources").remove(this.resources);
        if (resources != null) {
            this.resources = new ResourceRequirementsBuilder(resources);
            this._visitables.get((Object)"resources").add(this.resources);
        } else {
            this.resources = null;
            this._visitables.get((Object)"resources").remove(this.resources);
        }
        return (A)this;
    }

    @Override
    public Boolean hasResources() {
        return this.resources != null;
    }

    @Override
    public CacheConfigFluent.ResourcesNested<A> withNewResources() {
        return new ResourcesNestedImpl();
    }

    @Override
    public CacheConfigFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
        return new ResourcesNestedImpl(item);
    }

    @Override
    public CacheConfigFluent.ResourcesNested<A> editResources() {
        return this.withNewResourcesLike(this.getResources());
    }

    @Override
    public CacheConfigFluent.ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(this.getResources() != null ? this.getResources() : new ResourceRequirementsBuilder().build());
    }

    @Override
    public CacheConfigFluent.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
        return this.withNewResourcesLike(this.getResources() != null ? this.getResources() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CacheConfigFluentImpl that = (CacheConfigFluentImpl)o;
        if (!Objects.equals(this.connectionLimit, that.connectionLimit)) {
            return false;
        }
        if (!Objects.equals(this.maxItemSize, that.maxItemSize)) {
            return false;
        }
        if (!Objects.equals(this.memoryLimitMb, that.memoryLimitMb)) {
            return false;
        }
        if (!Objects.equals(this.replicas, that.replicas)) {
            return false;
        }
        return Objects.equals(this.resources, that.resources);
    }

    public int hashCode() {
        return Objects.hash(this.connectionLimit, this.maxItemSize, this.memoryLimitMb, this.replicas, this.resources, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.connectionLimit != null) {
            sb.append("connectionLimit:");
            sb.append(this.connectionLimit + ",");
        }
        if (this.maxItemSize != null) {
            sb.append("maxItemSize:");
            sb.append(this.maxItemSize + ",");
        }
        if (this.memoryLimitMb != null) {
            sb.append("memoryLimitMb:");
            sb.append(this.memoryLimitMb + ",");
        }
        if (this.replicas != null) {
            sb.append("replicas:");
            sb.append(this.replicas + ",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append(this.resources);
        }
        sb.append("}");
        return sb.toString();
    }

    class ResourcesNestedImpl<N>
    extends ResourceRequirementsFluentImpl<CacheConfigFluent.ResourcesNested<N>>
    implements CacheConfigFluent.ResourcesNested<N>,
    Nested<N> {
        ResourceRequirementsBuilder builder;

        ResourcesNestedImpl(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder((ResourceRequirementsFluent)this, item);
        }

        ResourcesNestedImpl() {
            this.builder = new ResourceRequirementsBuilder((ResourceRequirementsFluent)this);
        }

        @Override
        public N and() {
            return (N)CacheConfigFluentImpl.this.withResources(this.builder.build());
        }

        @Override
        public N endResources() {
            return this.and();
        }
    }
}

