package io.fabric8.openclustermanagement.api.model.multiclusterobservabilityoperator.apps.v1beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StorageConfigBuilder extends StorageConfigFluentImpl<StorageConfigBuilder> implements VisitableBuilder<StorageConfig,StorageConfigBuilder>{
  public StorageConfigBuilder() {
    this(false);
  }
  public StorageConfigBuilder(Boolean validationEnabled) {
    this(new StorageConfig(), validationEnabled);
  }
  public StorageConfigBuilder(StorageConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public StorageConfigBuilder(StorageConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StorageConfig(), validationEnabled);
  }
  public StorageConfigBuilder(StorageConfigFluent<?> fluent,StorageConfig instance) {
    this(fluent, instance, false);
  }
  public StorageConfigBuilder(StorageConfigFluent<?> fluent,StorageConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAlertmanagerStorageSize(instance.getAlertmanagerStorageSize());
      fluent.withCompactStorageSize(instance.getCompactStorageSize());
      fluent.withMetricObjectStorage(instance.getMetricObjectStorage());
      fluent.withReceiveStorageSize(instance.getReceiveStorageSize());
      fluent.withRuleStorageSize(instance.getRuleStorageSize());
      fluent.withStorageClass(instance.getStorageClass());
      fluent.withStoreStorageSize(instance.getStoreStorageSize());
    }
    this.validationEnabled = validationEnabled; 
  }
  public StorageConfigBuilder(StorageConfig instance) {
    this(instance,false);
  }
  public StorageConfigBuilder(StorageConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAlertmanagerStorageSize(instance.getAlertmanagerStorageSize());
      this.withCompactStorageSize(instance.getCompactStorageSize());
      this.withMetricObjectStorage(instance.getMetricObjectStorage());
      this.withReceiveStorageSize(instance.getReceiveStorageSize());
      this.withRuleStorageSize(instance.getRuleStorageSize());
      this.withStorageClass(instance.getStorageClass());
      this.withStoreStorageSize(instance.getStoreStorageSize());
    }
    this.validationEnabled = validationEnabled; 
  }
  StorageConfigFluent<?> fluent;
  Boolean validationEnabled;
  public StorageConfig build() {
    StorageConfig buildable = new StorageConfig(fluent.getAlertmanagerStorageSize(),fluent.getCompactStorageSize(),fluent.getMetricObjectStorage(),fluent.getReceiveStorageSize(),fluent.getRuleStorageSize(),fluent.getStorageClass(),fluent.getStoreStorageSize());
    return buildable;
  }
  
}