package io.fabric8.openclustermanagement.api.model.multiclusterobservabilityoperator.apps.v1beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RetentionConfigBuilder extends RetentionConfigFluentImpl<RetentionConfigBuilder> implements VisitableBuilder<RetentionConfig,RetentionConfigBuilder>{
  public RetentionConfigBuilder() {
    this(false);
  }
  public RetentionConfigBuilder(Boolean validationEnabled) {
    this(new RetentionConfig(), validationEnabled);
  }
  public RetentionConfigBuilder(RetentionConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public RetentionConfigBuilder(RetentionConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RetentionConfig(), validationEnabled);
  }
  public RetentionConfigBuilder(RetentionConfigFluent<?> fluent,RetentionConfig instance) {
    this(fluent, instance, false);
  }
  public RetentionConfigBuilder(RetentionConfigFluent<?> fluent,RetentionConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withBlockDuration(instance.getBlockDuration());
      fluent.withDeleteDelay(instance.getDeleteDelay());
      fluent.withRetentionInLocal(instance.getRetentionInLocal());
      fluent.withRetentionResolution1h(instance.getRetentionResolution1h());
      fluent.withRetentionResolution5m(instance.getRetentionResolution5m());
      fluent.withRetentionResolutionRaw(instance.getRetentionResolutionRaw());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RetentionConfigBuilder(RetentionConfig instance) {
    this(instance,false);
  }
  public RetentionConfigBuilder(RetentionConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withBlockDuration(instance.getBlockDuration());
      this.withDeleteDelay(instance.getDeleteDelay());
      this.withRetentionInLocal(instance.getRetentionInLocal());
      this.withRetentionResolution1h(instance.getRetentionResolution1h());
      this.withRetentionResolution5m(instance.getRetentionResolution5m());
      this.withRetentionResolutionRaw(instance.getRetentionResolutionRaw());
    }
    this.validationEnabled = validationEnabled; 
  }
  RetentionConfigFluent<?> fluent;
  Boolean validationEnabled;
  public RetentionConfig build() {
    RetentionConfig buildable = new RetentionConfig(fluent.getBlockDuration(),fluent.getDeleteDelay(),fluent.getRetentionInLocal(),fluent.getRetentionResolution1h(),fluent.getRetentionResolution5m(),fluent.getRetentionResolutionRaw());
    return buildable;
  }
  
}