package io.fabric8.openclustermanagement.api.model.multiclusterobservabilityoperator.apps.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ObservabilityAddonListBuilder extends ObservabilityAddonListFluentImpl<ObservabilityAddonListBuilder> implements VisitableBuilder<ObservabilityAddonList,ObservabilityAddonListBuilder>{
  public ObservabilityAddonListBuilder() {
    this(false);
  }
  public ObservabilityAddonListBuilder(Boolean validationEnabled) {
    this(new ObservabilityAddonList(), validationEnabled);
  }
  public ObservabilityAddonListBuilder(ObservabilityAddonListFluent<?> fluent) {
    this(fluent, false);
  }
  public ObservabilityAddonListBuilder(ObservabilityAddonListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ObservabilityAddonList(), validationEnabled);
  }
  public ObservabilityAddonListBuilder(ObservabilityAddonListFluent<?> fluent,ObservabilityAddonList instance) {
    this(fluent, instance, false);
  }
  public ObservabilityAddonListBuilder(ObservabilityAddonListFluent<?> fluent,ObservabilityAddonList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ObservabilityAddonListBuilder(ObservabilityAddonList instance) {
    this(instance,false);
  }
  public ObservabilityAddonListBuilder(ObservabilityAddonList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  ObservabilityAddonListFluent<?> fluent;
  Boolean validationEnabled;
  public ObservabilityAddonList build() {
    ObservabilityAddonList buildable = new ObservabilityAddonList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}