package io.fabric8.openclustermanagement.api.model.multiclusterobservabilityoperator.apps.v1beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MultiClusterObservabilityStatusBuilder extends MultiClusterObservabilityStatusFluentImpl<MultiClusterObservabilityStatusBuilder> implements VisitableBuilder<MultiClusterObservabilityStatus,MultiClusterObservabilityStatusBuilder>{
  public MultiClusterObservabilityStatusBuilder() {
    this(false);
  }
  public MultiClusterObservabilityStatusBuilder(Boolean validationEnabled) {
    this(new MultiClusterObservabilityStatus(), validationEnabled);
  }
  public MultiClusterObservabilityStatusBuilder(MultiClusterObservabilityStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public MultiClusterObservabilityStatusBuilder(MultiClusterObservabilityStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MultiClusterObservabilityStatus(), validationEnabled);
  }
  public MultiClusterObservabilityStatusBuilder(MultiClusterObservabilityStatusFluent<?> fluent,MultiClusterObservabilityStatus instance) {
    this(fluent, instance, false);
  }
  public MultiClusterObservabilityStatusBuilder(MultiClusterObservabilityStatusFluent<?> fluent,MultiClusterObservabilityStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withConditions(instance.getConditions());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MultiClusterObservabilityStatusBuilder(MultiClusterObservabilityStatus instance) {
    this(instance,false);
  }
  public MultiClusterObservabilityStatusBuilder(MultiClusterObservabilityStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withConditions(instance.getConditions());
    }
    this.validationEnabled = validationEnabled; 
  }
  MultiClusterObservabilityStatusFluent<?> fluent;
  Boolean validationEnabled;
  public MultiClusterObservabilityStatus build() {
    MultiClusterObservabilityStatus buildable = new MultiClusterObservabilityStatus(fluent.getConditions());
    return buildable;
  }
  
}