package io.fabric8.openclustermanagement.api.model.multiclusterobservabilityoperator.apps.v1beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CompactSpecBuilder extends CompactSpecFluentImpl<CompactSpecBuilder> implements VisitableBuilder<CompactSpec,CompactSpecBuilder>{
  public CompactSpecBuilder() {
    this(false);
  }
  public CompactSpecBuilder(Boolean validationEnabled) {
    this(new CompactSpec(), validationEnabled);
  }
  public CompactSpecBuilder(CompactSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public CompactSpecBuilder(CompactSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CompactSpec(), validationEnabled);
  }
  public CompactSpecBuilder(CompactSpecFluent<?> fluent,CompactSpec instance) {
    this(fluent, instance, false);
  }
  public CompactSpecBuilder(CompactSpecFluent<?> fluent,CompactSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withResources(instance.getResources()); 
    this.validationEnabled = validationEnabled; 
  }
  public CompactSpecBuilder(CompactSpec instance) {
    this(instance,false);
  }
  public CompactSpecBuilder(CompactSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withResources(instance.getResources()); 
    this.validationEnabled = validationEnabled; 
  }
  CompactSpecFluent<?> fluent;
  Boolean validationEnabled;
  public CompactSpec build() {
    CompactSpec buildable = new CompactSpec(fluent.getResources());
    return buildable;
  }
  
}