package io.fabric8.openclustermanagement.api.model.multiclusterobservabilityoperator.apps.v1beta2;

import io.fabric8.openclustermanagement.api.model.multiclusterobservabilityoperator.shared.ObservabilityAddonSpec;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.openclustermanagement.api.model.multiclusterobservabilityoperator.shared.ObservabilityAddonSpecBuilder;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import io.fabric8.openclustermanagement.api.model.multiclusterobservabilityoperator.shared.ObservabilityAddonSpecFluentImpl;
import io.fabric8.kubernetes.api.model.Toleration;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class MultiClusterObservabilitySpecFluentImpl<A extends MultiClusterObservabilitySpecFluent<A>> extends BaseFluent<A> implements MultiClusterObservabilitySpecFluent<A>{
  public MultiClusterObservabilitySpecFluentImpl() {
  }
  public MultiClusterObservabilitySpecFluentImpl(MultiClusterObservabilitySpec instance) {
    this.withAdvanced(instance.getAdvanced()); 
    this.withEnableDownsampling(instance.getEnableDownsampling()); 
    this.withImagePullPolicy(instance.getImagePullPolicy()); 
    this.withImagePullSecret(instance.getImagePullSecret()); 
    this.withNodeSelector(instance.getNodeSelector()); 
    this.withObservabilityAddonSpec(instance.getObservabilityAddonSpec()); 
    this.withStorageConfig(instance.getStorageConfig()); 
    this.withTolerations(instance.getTolerations()); 
  }
  private AdvancedConfigBuilder advanced;
  private Boolean enableDownsampling;
  private String imagePullPolicy;
  private String imagePullSecret;
  private Map<String,String> nodeSelector;
  private ObservabilityAddonSpecBuilder observabilityAddonSpec;
  private StorageConfigBuilder storageConfig;
  private List<Toleration> tolerations = new ArrayList<Toleration>();
  
  /**
   * This method has been deprecated, please use method buildAdvanced instead.
   * @return The buildable object.
   */
  @Deprecated
  public AdvancedConfig getAdvanced() {
    return this.advanced!=null ?this.advanced.build():null;
  }
  public AdvancedConfig buildAdvanced() {
    return this.advanced!=null ?this.advanced.build():null;
  }
  public A withAdvanced(AdvancedConfig advanced) {
    _visitables.get("advanced").remove(this.advanced);
    if (advanced!=null){ this.advanced= new AdvancedConfigBuilder(advanced); _visitables.get("advanced").add(this.advanced);} else { this.advanced = null; _visitables.get("advanced").remove(this.advanced); } return (A) this;
  }
  public Boolean hasAdvanced() {
    return this.advanced != null;
  }
  public MultiClusterObservabilitySpecFluent.AdvancedNested<A> withNewAdvanced() {
    return new MultiClusterObservabilitySpecFluentImpl.AdvancedNestedImpl();
  }
  public MultiClusterObservabilitySpecFluent.AdvancedNested<A> withNewAdvancedLike(AdvancedConfig item) {
    return new MultiClusterObservabilitySpecFluentImpl.AdvancedNestedImpl(item);
  }
  public MultiClusterObservabilitySpecFluent.AdvancedNested<A> editAdvanced() {
    return withNewAdvancedLike(getAdvanced());
  }
  public MultiClusterObservabilitySpecFluent.AdvancedNested<A> editOrNewAdvanced() {
    return withNewAdvancedLike(getAdvanced() != null ? getAdvanced(): new AdvancedConfigBuilder().build());
  }
  public MultiClusterObservabilitySpecFluent.AdvancedNested<A> editOrNewAdvancedLike(AdvancedConfig item) {
    return withNewAdvancedLike(getAdvanced() != null ? getAdvanced(): item);
  }
  public Boolean getEnableDownsampling() {
    return this.enableDownsampling;
  }
  public A withEnableDownsampling(Boolean enableDownsampling) {
    this.enableDownsampling=enableDownsampling; return (A) this;
  }
  public Boolean hasEnableDownsampling() {
    return this.enableDownsampling != null;
  }
  public String getImagePullPolicy() {
    return this.imagePullPolicy;
  }
  public A withImagePullPolicy(String imagePullPolicy) {
    this.imagePullPolicy=imagePullPolicy; return (A) this;
  }
  public Boolean hasImagePullPolicy() {
    return this.imagePullPolicy != null;
  }
  public String getImagePullSecret() {
    return this.imagePullSecret;
  }
  public A withImagePullSecret(String imagePullSecret) {
    this.imagePullSecret=imagePullSecret; return (A) this;
  }
  public Boolean hasImagePullSecret() {
    return this.imagePullSecret != null;
  }
  public A addToNodeSelector(String key,String value) {
    if(this.nodeSelector == null && key != null && value != null) { this.nodeSelector = new LinkedHashMap(); }
    if(key != null && value != null) {this.nodeSelector.put(key, value);} return (A)this;
  }
  public A addToNodeSelector(Map<String,String> map) {
    if(this.nodeSelector == null && map != null) { this.nodeSelector = new LinkedHashMap(); }
    if(map != null) { this.nodeSelector.putAll(map);} return (A)this;
  }
  public A removeFromNodeSelector(String key) {
    if(this.nodeSelector == null) { return (A) this; }
    if(key != null && this.nodeSelector != null) {this.nodeSelector.remove(key);} return (A)this;
  }
  public A removeFromNodeSelector(Map<String,String> map) {
    if(this.nodeSelector == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.nodeSelector != null){this.nodeSelector.remove(key);}}} return (A)this;
  }
  public Map<String,String> getNodeSelector() {
    return this.nodeSelector;
  }
  public <K,V>A withNodeSelector(Map<String,String> nodeSelector) {
    if (nodeSelector == null) { this.nodeSelector =  null;} else {this.nodeSelector = new LinkedHashMap(nodeSelector);} return (A) this;
  }
  public Boolean hasNodeSelector() {
    return this.nodeSelector != null;
  }
  
  /**
   * This method has been deprecated, please use method buildObservabilityAddonSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObservabilityAddonSpec getObservabilityAddonSpec() {
    return this.observabilityAddonSpec!=null ?this.observabilityAddonSpec.build():null;
  }
  public ObservabilityAddonSpec buildObservabilityAddonSpec() {
    return this.observabilityAddonSpec!=null ?this.observabilityAddonSpec.build():null;
  }
  public A withObservabilityAddonSpec(ObservabilityAddonSpec observabilityAddonSpec) {
    _visitables.get("observabilityAddonSpec").remove(this.observabilityAddonSpec);
    if (observabilityAddonSpec!=null){ this.observabilityAddonSpec= new ObservabilityAddonSpecBuilder(observabilityAddonSpec); _visitables.get("observabilityAddonSpec").add(this.observabilityAddonSpec);} else { this.observabilityAddonSpec = null; _visitables.get("observabilityAddonSpec").remove(this.observabilityAddonSpec); } return (A) this;
  }
  public Boolean hasObservabilityAddonSpec() {
    return this.observabilityAddonSpec != null;
  }
  public MultiClusterObservabilitySpecFluent.ObservabilityAddonSpecNested<A> withNewObservabilityAddonSpec() {
    return new MultiClusterObservabilitySpecFluentImpl.ObservabilityAddonSpecNestedImpl();
  }
  public MultiClusterObservabilitySpecFluent.ObservabilityAddonSpecNested<A> withNewObservabilityAddonSpecLike(ObservabilityAddonSpec item) {
    return new MultiClusterObservabilitySpecFluentImpl.ObservabilityAddonSpecNestedImpl(item);
  }
  public MultiClusterObservabilitySpecFluent.ObservabilityAddonSpecNested<A> editObservabilityAddonSpec() {
    return withNewObservabilityAddonSpecLike(getObservabilityAddonSpec());
  }
  public MultiClusterObservabilitySpecFluent.ObservabilityAddonSpecNested<A> editOrNewObservabilityAddonSpec() {
    return withNewObservabilityAddonSpecLike(getObservabilityAddonSpec() != null ? getObservabilityAddonSpec(): new ObservabilityAddonSpecBuilder().build());
  }
  public MultiClusterObservabilitySpecFluent.ObservabilityAddonSpecNested<A> editOrNewObservabilityAddonSpecLike(ObservabilityAddonSpec item) {
    return withNewObservabilityAddonSpecLike(getObservabilityAddonSpec() != null ? getObservabilityAddonSpec(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStorageConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public StorageConfig getStorageConfig() {
    return this.storageConfig!=null ?this.storageConfig.build():null;
  }
  public StorageConfig buildStorageConfig() {
    return this.storageConfig!=null ?this.storageConfig.build():null;
  }
  public A withStorageConfig(StorageConfig storageConfig) {
    _visitables.get("storageConfig").remove(this.storageConfig);
    if (storageConfig!=null){ this.storageConfig= new StorageConfigBuilder(storageConfig); _visitables.get("storageConfig").add(this.storageConfig);} else { this.storageConfig = null; _visitables.get("storageConfig").remove(this.storageConfig); } return (A) this;
  }
  public Boolean hasStorageConfig() {
    return this.storageConfig != null;
  }
  public MultiClusterObservabilitySpecFluent.StorageConfigNested<A> withNewStorageConfig() {
    return new MultiClusterObservabilitySpecFluentImpl.StorageConfigNestedImpl();
  }
  public MultiClusterObservabilitySpecFluent.StorageConfigNested<A> withNewStorageConfigLike(StorageConfig item) {
    return new MultiClusterObservabilitySpecFluentImpl.StorageConfigNestedImpl(item);
  }
  public MultiClusterObservabilitySpecFluent.StorageConfigNested<A> editStorageConfig() {
    return withNewStorageConfigLike(getStorageConfig());
  }
  public MultiClusterObservabilitySpecFluent.StorageConfigNested<A> editOrNewStorageConfig() {
    return withNewStorageConfigLike(getStorageConfig() != null ? getStorageConfig(): new StorageConfigBuilder().build());
  }
  public MultiClusterObservabilitySpecFluent.StorageConfigNested<A> editOrNewStorageConfigLike(StorageConfig item) {
    return withNewStorageConfigLike(getStorageConfig() != null ? getStorageConfig(): item);
  }
  public A addToTolerations(Integer index,Toleration item) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    this.tolerations.add(index, item);
    return (A)this;
  }
  public A setToTolerations(Integer index,Toleration item) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    this.tolerations.set(index, item); return (A)this;
  }
  public A addToTolerations(io.fabric8.kubernetes.api.model.Toleration... items) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
  }
  public A addAllToTolerations(Collection<Toleration> items) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
  }
  public A removeFromTolerations(io.fabric8.kubernetes.api.model.Toleration... items) {
    for (Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
  }
  public A removeAllFromTolerations(Collection<Toleration> items) {
    for (Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
  }
  public List<Toleration> getTolerations() {
    return this.tolerations;
  }
  public Toleration getToleration(Integer index) {
    return this.tolerations.get(index);
  }
  public Toleration getFirstToleration() {
    return this.tolerations.get(0);
  }
  public Toleration getLastToleration() {
    return this.tolerations.get(tolerations.size() - 1);
  }
  public Toleration getMatchingToleration(Predicate<Toleration> predicate) {
    for (Toleration item: tolerations) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingToleration(Predicate<Toleration> predicate) {
    for (Toleration item: tolerations) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTolerations(List<Toleration> tolerations) {
    if (tolerations != null) {this.tolerations = new ArrayList(); for (Toleration item : tolerations){this.addToTolerations(item);}} else { this.tolerations = null;} return (A) this;
  }
  public A withTolerations(io.fabric8.kubernetes.api.model.Toleration... tolerations) {
    if (this.tolerations != null) {this.tolerations.clear();}
    if (tolerations != null) {for (Toleration item :tolerations){ this.addToTolerations(item);}} return (A) this;
  }
  public Boolean hasTolerations() {
    return tolerations != null && !tolerations.isEmpty();
  }
  public A addNewToleration(String effect,String key,String operator,Long tolerationSeconds,String value) {
    return (A)addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MultiClusterObservabilitySpecFluentImpl that = (MultiClusterObservabilitySpecFluentImpl) o;
    if (advanced != null ? !advanced.equals(that.advanced) :that.advanced != null) return false;
    if (enableDownsampling != null ? !enableDownsampling.equals(that.enableDownsampling) :that.enableDownsampling != null) return false;
    if (imagePullPolicy != null ? !imagePullPolicy.equals(that.imagePullPolicy) :that.imagePullPolicy != null) return false;
    if (imagePullSecret != null ? !imagePullSecret.equals(that.imagePullSecret) :that.imagePullSecret != null) return false;
    if (nodeSelector != null ? !nodeSelector.equals(that.nodeSelector) :that.nodeSelector != null) return false;
    if (observabilityAddonSpec != null ? !observabilityAddonSpec.equals(that.observabilityAddonSpec) :that.observabilityAddonSpec != null) return false;
    if (storageConfig != null ? !storageConfig.equals(that.storageConfig) :that.storageConfig != null) return false;
    if (tolerations != null ? !tolerations.equals(that.tolerations) :that.tolerations != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(advanced,  enableDownsampling,  imagePullPolicy,  imagePullSecret,  nodeSelector,  observabilityAddonSpec,  storageConfig,  tolerations,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (advanced != null) { sb.append("advanced:"); sb.append(advanced + ","); }
    if (enableDownsampling != null) { sb.append("enableDownsampling:"); sb.append(enableDownsampling + ","); }
    if (imagePullPolicy != null) { sb.append("imagePullPolicy:"); sb.append(imagePullPolicy + ","); }
    if (imagePullSecret != null) { sb.append("imagePullSecret:"); sb.append(imagePullSecret + ","); }
    if (nodeSelector != null && !nodeSelector.isEmpty()) { sb.append("nodeSelector:"); sb.append(nodeSelector + ","); }
    if (observabilityAddonSpec != null) { sb.append("observabilityAddonSpec:"); sb.append(observabilityAddonSpec + ","); }
    if (storageConfig != null) { sb.append("storageConfig:"); sb.append(storageConfig + ","); }
    if (tolerations != null && !tolerations.isEmpty()) { sb.append("tolerations:"); sb.append(tolerations); }
    sb.append("}");
    return sb.toString();
  }
  public A withEnableDownsampling() {
    return withEnableDownsampling(true);
  }
  class AdvancedNestedImpl<N> extends AdvancedConfigFluentImpl<MultiClusterObservabilitySpecFluent.AdvancedNested<N>> implements MultiClusterObservabilitySpecFluent.AdvancedNested<N>,Nested<N>{
    AdvancedNestedImpl(AdvancedConfig item) {
      this.builder = new AdvancedConfigBuilder(this, item);
    }
    AdvancedNestedImpl() {
      this.builder = new AdvancedConfigBuilder(this);
    }
    AdvancedConfigBuilder builder;
    public N and() {
      return (N) MultiClusterObservabilitySpecFluentImpl.this.withAdvanced(builder.build());
    }
    public N endAdvanced() {
      return and();
    }
    
  }
  class ObservabilityAddonSpecNestedImpl<N> extends ObservabilityAddonSpecFluentImpl<MultiClusterObservabilitySpecFluent.ObservabilityAddonSpecNested<N>> implements MultiClusterObservabilitySpecFluent.ObservabilityAddonSpecNested<N>,Nested<N>{
    ObservabilityAddonSpecNestedImpl(ObservabilityAddonSpec item) {
      this.builder = new ObservabilityAddonSpecBuilder(this, item);
    }
    ObservabilityAddonSpecNestedImpl() {
      this.builder = new ObservabilityAddonSpecBuilder(this);
    }
    ObservabilityAddonSpecBuilder builder;
    public N and() {
      return (N) MultiClusterObservabilitySpecFluentImpl.this.withObservabilityAddonSpec(builder.build());
    }
    public N endObservabilityAddonSpec() {
      return and();
    }
    
  }
  class StorageConfigNestedImpl<N> extends StorageConfigFluentImpl<MultiClusterObservabilitySpecFluent.StorageConfigNested<N>> implements MultiClusterObservabilitySpecFluent.StorageConfigNested<N>,Nested<N>{
    StorageConfigNestedImpl(StorageConfig item) {
      this.builder = new StorageConfigBuilder(this, item);
    }
    StorageConfigNestedImpl() {
      this.builder = new StorageConfigBuilder(this);
    }
    StorageConfigBuilder builder;
    public N and() {
      return (N) MultiClusterObservabilitySpecFluentImpl.this.withStorageConfig(builder.build());
    }
    public N endStorageConfig() {
      return and();
    }
    
  }
  
}