package io.fabric8.openclustermanagement.api.model.multiclusterobservabilityoperator.apps.v1beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RuleSpecBuilder extends RuleSpecFluentImpl<RuleSpecBuilder> implements VisitableBuilder<RuleSpec,RuleSpecBuilder>{
  public RuleSpecBuilder() {
    this(false);
  }
  public RuleSpecBuilder(Boolean validationEnabled) {
    this(new RuleSpec(), validationEnabled);
  }
  public RuleSpecBuilder(RuleSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public RuleSpecBuilder(RuleSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RuleSpec(), validationEnabled);
  }
  public RuleSpecBuilder(RuleSpecFluent<?> fluent,RuleSpec instance) {
    this(fluent, instance, false);
  }
  public RuleSpecBuilder(RuleSpecFluent<?> fluent,RuleSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withEvalInterval(instance.getEvalInterval()); 
    fluent.withReplicas(instance.getReplicas()); 
    fluent.withResources(instance.getResources()); 
    this.validationEnabled = validationEnabled; 
  }
  public RuleSpecBuilder(RuleSpec instance) {
    this(instance,false);
  }
  public RuleSpecBuilder(RuleSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withEvalInterval(instance.getEvalInterval()); 
    this.withReplicas(instance.getReplicas()); 
    this.withResources(instance.getResources()); 
    this.validationEnabled = validationEnabled; 
  }
  RuleSpecFluent<?> fluent;
  Boolean validationEnabled;
  public RuleSpec build() {
    RuleSpec buildable = new RuleSpec(fluent.getEvalInterval(),fluent.getReplicas(),fluent.getResources());
    return buildable;
  }
  
}