package io.fabric8.openclustermanagement.api.model.multiclusterobservabilityoperator.apps.v1beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ObservatoriumConfigBuilder extends ObservatoriumConfigFluentImpl<ObservatoriumConfigBuilder> implements VisitableBuilder<ObservatoriumConfig,ObservatoriumConfigBuilder>{
  public ObservatoriumConfigBuilder() {
    this(false);
  }
  public ObservatoriumConfigBuilder(Boolean validationEnabled) {
    this(new ObservatoriumConfig(), validationEnabled);
  }
  public ObservatoriumConfigBuilder(ObservatoriumConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public ObservatoriumConfigBuilder(ObservatoriumConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ObservatoriumConfig(), validationEnabled);
  }
  public ObservatoriumConfigBuilder(ObservatoriumConfigFluent<?> fluent,ObservatoriumConfig instance) {
    this(fluent, instance, false);
  }
  public ObservatoriumConfigBuilder(ObservatoriumConfigFluent<?> fluent,ObservatoriumConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withTenantHeader(instance.getTenantHeader()); 
    fluent.withWriteEndpoint(instance.getWriteEndpoint()); 
    this.validationEnabled = validationEnabled; 
  }
  public ObservatoriumConfigBuilder(ObservatoriumConfig instance) {
    this(instance,false);
  }
  public ObservatoriumConfigBuilder(ObservatoriumConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withTenantHeader(instance.getTenantHeader()); 
    this.withWriteEndpoint(instance.getWriteEndpoint()); 
    this.validationEnabled = validationEnabled; 
  }
  ObservatoriumConfigFluent<?> fluent;
  Boolean validationEnabled;
  public ObservatoriumConfig build() {
    ObservatoriumConfig buildable = new ObservatoriumConfig(fluent.getTenantHeader(),fluent.getWriteEndpoint());
    return buildable;
  }
  
}