package io.fabric8.openclustermanagement.api.model.multiclusterobservabilityoperator.shared;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PreConfiguredStorageBuilder extends PreConfiguredStorageFluent<PreConfiguredStorageBuilder> implements VisitableBuilder<PreConfiguredStorage,PreConfiguredStorageBuilder>{
  public PreConfiguredStorageBuilder() {
    this(new PreConfiguredStorage());
  }
  
  public PreConfiguredStorageBuilder(PreConfiguredStorageFluent<?> fluent) {
    this(fluent, new PreConfiguredStorage());
  }
  
  public PreConfiguredStorageBuilder(PreConfiguredStorageFluent<?> fluent,PreConfiguredStorage instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PreConfiguredStorageBuilder(PreConfiguredStorage instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PreConfiguredStorageFluent<?> fluent;
  
  public PreConfiguredStorage build() {
    PreConfiguredStorage buildable = new PreConfiguredStorage(fluent.getKey(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}