package io.fabric8.openclustermanagement.api.model.multiclusterobservabilityoperator.apps.v1beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class CacheConfigBuilder extends CacheConfigFluent<CacheConfigBuilder> implements VisitableBuilder<CacheConfig,CacheConfigBuilder>{
  public CacheConfigBuilder() {
    this(new CacheConfig());
  }
  
  public CacheConfigBuilder(CacheConfigFluent<?> fluent) {
    this(fluent, new CacheConfig());
  }
  
  public CacheConfigBuilder(CacheConfigFluent<?> fluent,CacheConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public CacheConfigBuilder(CacheConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  CacheConfigFluent<?> fluent;
  
  public CacheConfig build() {
    CacheConfig buildable = new CacheConfig(fluent.getConnectionLimit(),fluent.getMaxItemSize(),fluent.getMemoryLimitMb(),fluent.getReplicas(),fluent.buildResources());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}