/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.multiclusterobservabilityoperator.apps.v1beta2;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.openclustermanagement.api.model.multiclusterobservabilityoperator.apps.v1beta2.CacheConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CacheConfigFluent<A extends CacheConfigFluent<A>>
extends BaseFluent<A> {
    private Integer connectionLimit;
    private String maxItemSize;
    private Integer memoryLimitMb;
    private Integer replicas;
    private ResourceRequirementsBuilder resources;
    private Map<String, Object> additionalProperties;

    public CacheConfigFluent() {
    }

    public CacheConfigFluent(CacheConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(CacheConfig instance) {
        CacheConfig cacheConfig = instance = instance != null ? instance : new CacheConfig();
        if (instance != null) {
            this.withConnectionLimit(instance.getConnectionLimit());
            this.withMaxItemSize(instance.getMaxItemSize());
            this.withMemoryLimitMb(instance.getMemoryLimitMb());
            this.withReplicas(instance.getReplicas());
            this.withResources(instance.getResources());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Integer getConnectionLimit() {
        return this.connectionLimit;
    }

    public A withConnectionLimit(Integer connectionLimit) {
        this.connectionLimit = connectionLimit;
        return (A)((Object)this);
    }

    public boolean hasConnectionLimit() {
        return this.connectionLimit != null;
    }

    public String getMaxItemSize() {
        return this.maxItemSize;
    }

    public A withMaxItemSize(String maxItemSize) {
        this.maxItemSize = maxItemSize;
        return (A)((Object)this);
    }

    public boolean hasMaxItemSize() {
        return this.maxItemSize != null;
    }

    public Integer getMemoryLimitMb() {
        return this.memoryLimitMb;
    }

    public A withMemoryLimitMb(Integer memoryLimitMb) {
        this.memoryLimitMb = memoryLimitMb;
        return (A)((Object)this);
    }

    public boolean hasMemoryLimitMb() {
        return this.memoryLimitMb != null;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)((Object)this);
    }

    public boolean hasReplicas() {
        return this.replicas != null;
    }

    public ResourceRequirements buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    public A withResources(ResourceRequirements resources) {
        this._visitables.remove((Object)"resources");
        if (resources != null) {
            this.resources = new ResourceRequirementsBuilder(resources);
            this._visitables.get((Object)"resources").add(this.resources);
        } else {
            this.resources = null;
            this._visitables.get((Object)"resources").remove(this.resources);
        }
        return (A)((Object)this);
    }

    public boolean hasResources() {
        return this.resources != null;
    }

    public ResourcesNested<A> withNewResources() {
        return new ResourcesNested(null);
    }

    public ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
        return new ResourcesNested(item);
    }

    public ResourcesNested<A> editResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(null));
    }

    public ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(new ResourceRequirementsBuilder().build()));
    }

    public ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CacheConfigFluent that = (CacheConfigFluent)((Object)o);
        if (!Objects.equals(this.connectionLimit, that.connectionLimit)) {
            return false;
        }
        if (!Objects.equals(this.maxItemSize, that.maxItemSize)) {
            return false;
        }
        if (!Objects.equals(this.memoryLimitMb, that.memoryLimitMb)) {
            return false;
        }
        if (!Objects.equals(this.replicas, that.replicas)) {
            return false;
        }
        if (!Objects.equals(this.resources, that.resources)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.connectionLimit, this.maxItemSize, this.memoryLimitMb, this.replicas, this.resources, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.connectionLimit != null) {
            sb.append("connectionLimit:");
            sb.append(this.connectionLimit + ",");
        }
        if (this.maxItemSize != null) {
            sb.append("maxItemSize:");
            sb.append(this.maxItemSize + ",");
        }
        if (this.memoryLimitMb != null) {
            sb.append("memoryLimitMb:");
            sb.append(this.memoryLimitMb + ",");
        }
        if (this.replicas != null) {
            sb.append("replicas:");
            sb.append(this.replicas + ",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ResourcesNested<N>
    extends ResourceRequirementsFluent<ResourcesNested<N>>
    implements Nested<N> {
        ResourceRequirementsBuilder builder;

        ResourcesNested(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder((ResourceRequirementsFluent)this, item);
        }

        public N and() {
            return (N)CacheConfigFluent.this.withResources(this.builder.build());
        }

        public N endResources() {
            return this.and();
        }
    }
}

