package io.fabric8.openclustermanagement.api.model.multiclusterobservabilityoperator.apps.v1beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class RuleSpecBuilder extends RuleSpecFluent<RuleSpecBuilder> implements VisitableBuilder<RuleSpec,RuleSpecBuilder>{
  public RuleSpecBuilder() {
    this(new RuleSpec());
  }
  
  public RuleSpecBuilder(RuleSpecFluent<?> fluent) {
    this(fluent, new RuleSpec());
  }
  
  public RuleSpecBuilder(RuleSpecFluent<?> fluent,RuleSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public RuleSpecBuilder(RuleSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  RuleSpecFluent<?> fluent;
  
  public RuleSpec build() {
    RuleSpec buildable = new RuleSpec(fluent.getEvalInterval(),fluent.getReplicas(),fluent.buildResources());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}