package io.fabric8.openclustermanagement.api.model.multiclusterobservabilityoperator.apps.v1beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StorageConfigBuilder extends StorageConfigFluentImpl<StorageConfigBuilder> implements VisitableBuilder<io.fabric8.openclustermanagement.api.model.multiclusterobservabilityoperator.apps.v1beta2.StorageConfig,StorageConfigBuilder>{
  public StorageConfigBuilder() {
    this(false);
  }
  public StorageConfigBuilder(Boolean validationEnabled) {
    this(new StorageConfig(), validationEnabled);
  }
  public StorageConfigBuilder(io.fabric8.openclustermanagement.api.model.multiclusterobservabilityoperator.apps.v1beta2.StorageConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public StorageConfigBuilder(io.fabric8.openclustermanagement.api.model.multiclusterobservabilityoperator.apps.v1beta2.StorageConfigFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new StorageConfig(), validationEnabled);
  }
  public StorageConfigBuilder(io.fabric8.openclustermanagement.api.model.multiclusterobservabilityoperator.apps.v1beta2.StorageConfigFluent<?> fluent,io.fabric8.openclustermanagement.api.model.multiclusterobservabilityoperator.apps.v1beta2.StorageConfig instance) {
    this(fluent, instance, false);
  }
  public StorageConfigBuilder(io.fabric8.openclustermanagement.api.model.multiclusterobservabilityoperator.apps.v1beta2.StorageConfigFluent<?> fluent,io.fabric8.openclustermanagement.api.model.multiclusterobservabilityoperator.apps.v1beta2.StorageConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAlertmanagerStorageSize(instance.getAlertmanagerStorageSize()); 
    fluent.withCompactStorageSize(instance.getCompactStorageSize()); 
    fluent.withMetricObjectStorage(instance.getMetricObjectStorage()); 
    fluent.withReceiveStorageSize(instance.getReceiveStorageSize()); 
    fluent.withRuleStorageSize(instance.getRuleStorageSize()); 
    fluent.withStorageClass(instance.getStorageClass()); 
    fluent.withStoreStorageSize(instance.getStoreStorageSize()); 
    this.validationEnabled = validationEnabled; 
  }
  public StorageConfigBuilder(io.fabric8.openclustermanagement.api.model.multiclusterobservabilityoperator.apps.v1beta2.StorageConfig instance) {
    this(instance,false);
  }
  public StorageConfigBuilder(io.fabric8.openclustermanagement.api.model.multiclusterobservabilityoperator.apps.v1beta2.StorageConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAlertmanagerStorageSize(instance.getAlertmanagerStorageSize()); 
    this.withCompactStorageSize(instance.getCompactStorageSize()); 
    this.withMetricObjectStorage(instance.getMetricObjectStorage()); 
    this.withReceiveStorageSize(instance.getReceiveStorageSize()); 
    this.withRuleStorageSize(instance.getRuleStorageSize()); 
    this.withStorageClass(instance.getStorageClass()); 
    this.withStoreStorageSize(instance.getStoreStorageSize()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openclustermanagement.api.model.multiclusterobservabilityoperator.apps.v1beta2.StorageConfigFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openclustermanagement.api.model.multiclusterobservabilityoperator.apps.v1beta2.StorageConfig build() {
    StorageConfig buildable = new StorageConfig(fluent.getAlertmanagerStorageSize(),fluent.getCompactStorageSize(),fluent.getMetricObjectStorage(),fluent.getReceiveStorageSize(),fluent.getRuleStorageSize(),fluent.getStorageClass(),fluent.getStoreStorageSize());
    return buildable;
  }
  
}