package io.fabric8.openclustermanagement.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class OpenClusterManagementDiscoverySchemaBuilder extends OpenClusterManagementDiscoverySchemaFluent<OpenClusterManagementDiscoverySchemaBuilder> implements VisitableBuilder<OpenClusterManagementDiscoverySchema,OpenClusterManagementDiscoverySchemaBuilder>{
  public OpenClusterManagementDiscoverySchemaBuilder() {
    this(new OpenClusterManagementDiscoverySchema());
  }
  
  public OpenClusterManagementDiscoverySchemaBuilder(OpenClusterManagementDiscoverySchemaFluent<?> fluent) {
    this(fluent, new OpenClusterManagementDiscoverySchema());
  }
  
  public OpenClusterManagementDiscoverySchemaBuilder(OpenClusterManagementDiscoverySchemaFluent<?> fluent,OpenClusterManagementDiscoverySchema instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public OpenClusterManagementDiscoverySchemaBuilder(OpenClusterManagementDiscoverySchema instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  OpenClusterManagementDiscoverySchemaFluent<?> fluent;
  
  public OpenClusterManagementDiscoverySchema build() {
    OpenClusterManagementDiscoverySchema buildable = new OpenClusterManagementDiscoverySchema(fluent.buildGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveredCluster(),fluent.buildGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveredClusterList(),fluent.buildGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveredClusterSpec(),fluent.buildGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveredClusterStatus(),fluent.buildGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveryConfig(),fluent.buildGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveryConfigList(),fluent.buildGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveryConfigSpec(),fluent.buildGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveryConfigStatus(),fluent.buildGithubComOpenClusterManagementDiscoveryApiV1alpha1Filter());
    return buildable;
  }
  

}