/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.discovery.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.Filter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class FilterFluent<A extends FilterFluent<A>>
extends BaseFluent<A> {
    private Integer lastActive;
    private List<String> openShiftVersions = new ArrayList<String>();

    public FilterFluent() {
    }

    public FilterFluent(Filter instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Filter instance) {
        Filter filter = instance = instance != null ? instance : new Filter();
        if (instance != null) {
            this.withLastActive(instance.getLastActive());
            this.withOpenShiftVersions(instance.getOpenShiftVersions());
            this.withLastActive(instance.getLastActive());
            this.withOpenShiftVersions(instance.getOpenShiftVersions());
        }
    }

    public Integer getLastActive() {
        return this.lastActive;
    }

    public A withLastActive(Integer lastActive) {
        this.lastActive = lastActive;
        return (A)((Object)this);
    }

    public boolean hasLastActive() {
        return this.lastActive != null;
    }

    public A addToOpenShiftVersions(int index, String item) {
        if (this.openShiftVersions == null) {
            this.openShiftVersions = new ArrayList<String>();
        }
        this.openShiftVersions.add(index, item);
        return (A)((Object)this);
    }

    public A setToOpenShiftVersions(int index, String item) {
        if (this.openShiftVersions == null) {
            this.openShiftVersions = new ArrayList<String>();
        }
        this.openShiftVersions.set(index, item);
        return (A)((Object)this);
    }

    public A addToOpenShiftVersions(String ... items) {
        if (this.openShiftVersions == null) {
            this.openShiftVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.openShiftVersions.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToOpenShiftVersions(Collection<String> items) {
        if (this.openShiftVersions == null) {
            this.openShiftVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.openShiftVersions.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromOpenShiftVersions(String ... items) {
        if (this.openShiftVersions == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.openShiftVersions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromOpenShiftVersions(Collection<String> items) {
        if (this.openShiftVersions == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.openShiftVersions.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getOpenShiftVersions() {
        return this.openShiftVersions;
    }

    public String getOpenShiftVersion(int index) {
        return this.openShiftVersions.get(index);
    }

    public String getFirstOpenShiftVersion() {
        return this.openShiftVersions.get(0);
    }

    public String getLastOpenShiftVersion() {
        return this.openShiftVersions.get(this.openShiftVersions.size() - 1);
    }

    public String getMatchingOpenShiftVersion(Predicate<String> predicate) {
        for (String item : this.openShiftVersions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingOpenShiftVersion(Predicate<String> predicate) {
        for (String item : this.openShiftVersions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withOpenShiftVersions(List<String> openShiftVersions) {
        if (openShiftVersions != null) {
            this.openShiftVersions = new ArrayList<String>();
            for (String item : openShiftVersions) {
                this.addToOpenShiftVersions(item);
            }
        } else {
            this.openShiftVersions = null;
        }
        return (A)((Object)this);
    }

    public A withOpenShiftVersions(String ... openShiftVersions) {
        if (this.openShiftVersions != null) {
            this.openShiftVersions.clear();
            this._visitables.remove((Object)"openShiftVersions");
        }
        if (openShiftVersions != null) {
            for (String item : openShiftVersions) {
                this.addToOpenShiftVersions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasOpenShiftVersions() {
        return this.openShiftVersions != null && !this.openShiftVersions.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FilterFluent that = (FilterFluent)((Object)o);
        if (!Objects.equals(this.lastActive, that.lastActive)) {
            return false;
        }
        return Objects.equals(this.openShiftVersions, that.openShiftVersions);
    }

    public int hashCode() {
        return Objects.hash(this.lastActive, this.openShiftVersions, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.lastActive != null) {
            sb.append("lastActive:");
            sb.append(this.lastActive + ",");
        }
        if (this.openShiftVersions != null && !this.openShiftVersions.isEmpty()) {
            sb.append("openShiftVersions:");
            sb.append(this.openShiftVersions);
        }
        sb.append("}");
        return sb.toString();
    }
}

