/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.discovery.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.DiscoveryConfigSpec;
import io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.Filter;
import io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.FilterBuilder;
import io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.FilterFluent;
import java.util.Objects;
import java.util.Optional;

public class DiscoveryConfigSpecFluent<A extends DiscoveryConfigSpecFluent<A>>
extends BaseFluent<A> {
    private String credential;
    private FilterBuilder filters;

    public DiscoveryConfigSpecFluent() {
    }

    public DiscoveryConfigSpecFluent(DiscoveryConfigSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(DiscoveryConfigSpec instance) {
        DiscoveryConfigSpec discoveryConfigSpec = instance = instance != null ? instance : new DiscoveryConfigSpec();
        if (instance != null) {
            this.withCredential(instance.getCredential());
            this.withFilters(instance.getFilters());
            this.withCredential(instance.getCredential());
            this.withFilters(instance.getFilters());
        }
    }

    public String getCredential() {
        return this.credential;
    }

    public A withCredential(String credential) {
        this.credential = credential;
        return (A)((Object)this);
    }

    public boolean hasCredential() {
        return this.credential != null;
    }

    public Filter buildFilters() {
        return this.filters != null ? this.filters.build() : null;
    }

    public A withFilters(Filter filters) {
        this._visitables.get((Object)"filters").remove((Object)this.filters);
        if (filters != null) {
            this.filters = new FilterBuilder(filters);
            this._visitables.get((Object)"filters").add(this.filters);
        } else {
            this.filters = null;
            this._visitables.get((Object)"filters").remove((Object)this.filters);
        }
        return (A)((Object)this);
    }

    public boolean hasFilters() {
        return this.filters != null;
    }

    public FiltersNested<A> withNewFilters() {
        return new FiltersNested(null);
    }

    public FiltersNested<A> withNewFiltersLike(Filter item) {
        return new FiltersNested(item);
    }

    public FiltersNested<A> editFilters() {
        return this.withNewFiltersLike(Optional.ofNullable(this.buildFilters()).orElse(null));
    }

    public FiltersNested<A> editOrNewFilters() {
        return this.withNewFiltersLike(Optional.ofNullable(this.buildFilters()).orElse(new FilterBuilder().build()));
    }

    public FiltersNested<A> editOrNewFiltersLike(Filter item) {
        return this.withNewFiltersLike(Optional.ofNullable(this.buildFilters()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DiscoveryConfigSpecFluent that = (DiscoveryConfigSpecFluent)((Object)o);
        if (!Objects.equals(this.credential, that.credential)) {
            return false;
        }
        return Objects.equals((Object)this.filters, (Object)that.filters);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.credential, this.filters, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.credential != null) {
            sb.append("credential:");
            sb.append(this.credential + ",");
        }
        if (this.filters != null) {
            sb.append("filters:");
            sb.append((Object)this.filters);
        }
        sb.append("}");
        return sb.toString();
    }

    public class FiltersNested<N>
    extends FilterFluent<FiltersNested<N>>
    implements Nested<N> {
        FilterBuilder builder;

        FiltersNested(Filter item) {
            this.builder = new FilterBuilder(this, item);
        }

        public N and() {
            return (N)DiscoveryConfigSpecFluent.this.withFilters(this.builder.build());
        }

        public N endFilters() {
            return this.and();
        }
    }
}

