package io.fabric8.openclustermanagement.api.model.discovery.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class DiscoveryConfigBuilder extends DiscoveryConfigFluent<DiscoveryConfigBuilder> implements VisitableBuilder<DiscoveryConfig,DiscoveryConfigBuilder>{
  public DiscoveryConfigBuilder() {
    this(new DiscoveryConfig());
  }
  
  public DiscoveryConfigBuilder(DiscoveryConfigFluent<?> fluent) {
    this(fluent, new DiscoveryConfig());
  }
  
  public DiscoveryConfigBuilder(DiscoveryConfigFluent<?> fluent,DiscoveryConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public DiscoveryConfigBuilder(DiscoveryConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  DiscoveryConfigFluent<?> fluent;
  
  public DiscoveryConfig build() {
    DiscoveryConfig buildable = new DiscoveryConfig(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  

}