package io.fabric8.openclustermanagement.api.model.discovery.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class DiscoveredClusterSpecFluent<A extends DiscoveredClusterSpecFluent<A>> extends BaseFluent<A>{
  public DiscoveredClusterSpecFluent() {
  }
  
  public DiscoveredClusterSpecFluent(DiscoveredClusterSpec instance) {
    this.copyInstance(instance);
  }
  private String activityTimestamp;
  private String apiUrl;
  private String cloudProvider;
  private String console;
  private String creationTimestamp;
  private ObjectReferenceBuilder credential;
  private String displayName;
  private Boolean isManagedCluster;
  private String name;
  private String openshiftVersion;
  private String status;
  private String type;
  
  protected void copyInstance(DiscoveredClusterSpec instance) {
    instance = (instance != null ? instance : new DiscoveredClusterSpec());
  
    if (instance != null) {
        this.withActivityTimestamp(instance.getActivityTimestamp());
        this.withApiUrl(instance.getApiUrl());
        this.withCloudProvider(instance.getCloudProvider());
        this.withConsole(instance.getConsole());
        this.withCreationTimestamp(instance.getCreationTimestamp());
        this.withCredential(instance.getCredential());
        this.withDisplayName(instance.getDisplayName());
        this.withIsManagedCluster(instance.getIsManagedCluster());
        this.withName(instance.getName());
        this.withOpenshiftVersion(instance.getOpenshiftVersion());
        this.withStatus(instance.getStatus());
        this.withType(instance.getType());
        this.withActivityTimestamp(instance.getActivityTimestamp());
        this.withApiUrl(instance.getApiUrl());
        this.withCloudProvider(instance.getCloudProvider());
        this.withConsole(instance.getConsole());
        this.withCreationTimestamp(instance.getCreationTimestamp());
        this.withCredential(instance.getCredential());
        this.withDisplayName(instance.getDisplayName());
        this.withIsManagedCluster(instance.getIsManagedCluster());
        this.withName(instance.getName());
        this.withOpenshiftVersion(instance.getOpenshiftVersion());
        this.withStatus(instance.getStatus());
        this.withType(instance.getType());
      }
  }
  
  public String getActivityTimestamp() {
    return this.activityTimestamp;
  }
  
  public A withActivityTimestamp(String activityTimestamp) {
    this.activityTimestamp=activityTimestamp; return (A) this;
  }
  
  public boolean hasActivityTimestamp() {
    return this.activityTimestamp != null;
  }
  
  public String getApiUrl() {
    return this.apiUrl;
  }
  
  public A withApiUrl(String apiUrl) {
    this.apiUrl=apiUrl; return (A) this;
  }
  
  public boolean hasApiUrl() {
    return this.apiUrl != null;
  }
  
  public String getCloudProvider() {
    return this.cloudProvider;
  }
  
  public A withCloudProvider(String cloudProvider) {
    this.cloudProvider=cloudProvider; return (A) this;
  }
  
  public boolean hasCloudProvider() {
    return this.cloudProvider != null;
  }
  
  public String getConsole() {
    return this.console;
  }
  
  public A withConsole(String console) {
    this.console=console; return (A) this;
  }
  
  public boolean hasConsole() {
    return this.console != null;
  }
  
  public String getCreationTimestamp() {
    return this.creationTimestamp;
  }
  
  public A withCreationTimestamp(String creationTimestamp) {
    this.creationTimestamp=creationTimestamp; return (A) this;
  }
  
  public boolean hasCreationTimestamp() {
    return this.creationTimestamp != null;
  }
  
  public ObjectReference buildCredential() {
    return this.credential!=null ?this.credential.build():null;
  }
  
  public A withCredential(ObjectReference credential) {
    _visitables.get("credential").remove(this.credential);
    if (credential!=null){ this.credential= new ObjectReferenceBuilder(credential); _visitables.get("credential").add(this.credential);} else { this.credential = null; _visitables.get("credential").remove(this.credential); } return (A) this;
  }
  
  public boolean hasCredential() {
    return this.credential != null;
  }
  
  public CredentialNested<A> withNewCredential() {
    return new CredentialNested(null);
  }
  
  public CredentialNested<A> withNewCredentialLike(ObjectReference item) {
    return new CredentialNested(item);
  }
  
  public CredentialNested<A> editCredential() {
    return withNewCredentialLike(java.util.Optional.ofNullable(buildCredential()).orElse(null));
  }
  
  public CredentialNested<A> editOrNewCredential() {
    return withNewCredentialLike(java.util.Optional.ofNullable(buildCredential()).orElse(new ObjectReferenceBuilder().build()));
  }
  
  public CredentialNested<A> editOrNewCredentialLike(ObjectReference item) {
    return withNewCredentialLike(java.util.Optional.ofNullable(buildCredential()).orElse(item));
  }
  
  public String getDisplayName() {
    return this.displayName;
  }
  
  public A withDisplayName(String displayName) {
    this.displayName=displayName; return (A) this;
  }
  
  public boolean hasDisplayName() {
    return this.displayName != null;
  }
  
  public Boolean getIsManagedCluster() {
    return this.isManagedCluster;
  }
  
  public A withIsManagedCluster(Boolean isManagedCluster) {
    this.isManagedCluster=isManagedCluster; return (A) this;
  }
  
  public boolean hasIsManagedCluster() {
    return this.isManagedCluster != null;
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public String getOpenshiftVersion() {
    return this.openshiftVersion;
  }
  
  public A withOpenshiftVersion(String openshiftVersion) {
    this.openshiftVersion=openshiftVersion; return (A) this;
  }
  
  public boolean hasOpenshiftVersion() {
    return this.openshiftVersion != null;
  }
  
  public String getStatus() {
    return this.status;
  }
  
  public A withStatus(String status) {
    this.status=status; return (A) this;
  }
  
  public boolean hasStatus() {
    return this.status != null;
  }
  
  public String getType() {
    return this.type;
  }
  
  public A withType(String type) {
    this.type=type; return (A) this;
  }
  
  public boolean hasType() {
    return this.type != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DiscoveredClusterSpecFluent that = (DiscoveredClusterSpecFluent) o;
    if (!java.util.Objects.equals(activityTimestamp, that.activityTimestamp)) return false;
  
    if (!java.util.Objects.equals(apiUrl, that.apiUrl)) return false;
  
    if (!java.util.Objects.equals(cloudProvider, that.cloudProvider)) return false;
  
    if (!java.util.Objects.equals(console, that.console)) return false;
  
    if (!java.util.Objects.equals(creationTimestamp, that.creationTimestamp)) return false;
  
    if (!java.util.Objects.equals(credential, that.credential)) return false;
  
    if (!java.util.Objects.equals(displayName, that.displayName)) return false;
  
    if (!java.util.Objects.equals(isManagedCluster, that.isManagedCluster)) return false;
  
    if (!java.util.Objects.equals(name, that.name)) return false;
  
    if (!java.util.Objects.equals(openshiftVersion, that.openshiftVersion)) return false;
  
    if (!java.util.Objects.equals(status, that.status)) return false;
  
    if (!java.util.Objects.equals(type, that.type)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(activityTimestamp,  apiUrl,  cloudProvider,  console,  creationTimestamp,  credential,  displayName,  isManagedCluster,  name,  openshiftVersion,  status,  type,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (activityTimestamp != null) { sb.append("activityTimestamp:"); sb.append(activityTimestamp + ","); }
    if (apiUrl != null) { sb.append("apiUrl:"); sb.append(apiUrl + ","); }
    if (cloudProvider != null) { sb.append("cloudProvider:"); sb.append(cloudProvider + ","); }
    if (console != null) { sb.append("console:"); sb.append(console + ","); }
    if (creationTimestamp != null) { sb.append("creationTimestamp:"); sb.append(creationTimestamp + ","); }
    if (credential != null) { sb.append("credential:"); sb.append(credential + ","); }
    if (displayName != null) { sb.append("displayName:"); sb.append(displayName + ","); }
    if (isManagedCluster != null) { sb.append("isManagedCluster:"); sb.append(isManagedCluster + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (openshiftVersion != null) { sb.append("openshiftVersion:"); sb.append(openshiftVersion + ","); }
    if (status != null) { sb.append("status:"); sb.append(status + ","); }
    if (type != null) { sb.append("type:"); sb.append(type); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withIsManagedCluster() {
    return withIsManagedCluster(true);
  }
  public class CredentialNested<N> extends ObjectReferenceFluent<CredentialNested<N>> implements Nested<N>{
    CredentialNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    
    public N and() {
      return (N) DiscoveredClusterSpecFluent.this.withCredential(builder.build());
    }
    
    public N endCredential() {
      return and();
    }
    
  
  }

}