package io.fabric8.openclustermanagement.api.model.discovery.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class FilterBuilder extends FilterFluent<FilterBuilder> implements VisitableBuilder<Filter,FilterBuilder>{
  public FilterBuilder() {
    this(false);
  }
  public FilterBuilder(Boolean validationEnabled) {
    this(new Filter(), validationEnabled);
  }
  public FilterBuilder(FilterFluent<?> fluent) {
    this(fluent, false);
  }
  public FilterBuilder(FilterFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Filter(), validationEnabled);
  }
  public FilterBuilder(FilterFluent<?> fluent,Filter instance) {
    this(fluent, instance, false);
  }
  public FilterBuilder(FilterFluent<?> fluent,Filter instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Filter());

    if (instance != null) {
      fluent.withLastActive(instance.getLastActive());
      fluent.withOpenShiftVersions(instance.getOpenShiftVersions());
      fluent.withLastActive(instance.getLastActive());
      fluent.withOpenShiftVersions(instance.getOpenShiftVersions());
    }
    this.validationEnabled = validationEnabled; 
  }
  public FilterBuilder(Filter instance) {
    this(instance,false);
  }
  public FilterBuilder(Filter instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Filter());

    if (instance != null) {
      this.withLastActive(instance.getLastActive());
      this.withOpenShiftVersions(instance.getOpenShiftVersions());
      this.withLastActive(instance.getLastActive());
      this.withOpenShiftVersions(instance.getOpenShiftVersions());
    }
    this.validationEnabled = validationEnabled; 
  }
  FilterFluent<?> fluent;
  Boolean validationEnabled;
  public Filter build() {
    Filter buildable = new Filter(fluent.getLastActive(),fluent.getOpenShiftVersions());
    return buildable;
  }
  
}