package io.fabric8.openclustermanagement.api.model.discovery.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DiscoveryConfigListBuilder extends DiscoveryConfigListFluent<DiscoveryConfigListBuilder> implements VisitableBuilder<DiscoveryConfigList,DiscoveryConfigListBuilder>{
  public DiscoveryConfigListBuilder() {
    this(false);
  }
  public DiscoveryConfigListBuilder(Boolean validationEnabled) {
    this(new DiscoveryConfigList(), validationEnabled);
  }
  public DiscoveryConfigListBuilder(DiscoveryConfigListFluent<?> fluent) {
    this(fluent, false);
  }
  public DiscoveryConfigListBuilder(DiscoveryConfigListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DiscoveryConfigList(), validationEnabled);
  }
  public DiscoveryConfigListBuilder(DiscoveryConfigListFluent<?> fluent,DiscoveryConfigList instance) {
    this(fluent, instance, false);
  }
  public DiscoveryConfigListBuilder(DiscoveryConfigListFluent<?> fluent,DiscoveryConfigList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new DiscoveryConfigList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DiscoveryConfigListBuilder(DiscoveryConfigList instance) {
    this(instance,false);
  }
  public DiscoveryConfigListBuilder(DiscoveryConfigList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new DiscoveryConfigList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  DiscoveryConfigListFluent<?> fluent;
  Boolean validationEnabled;
  public DiscoveryConfigList build() {
    DiscoveryConfigList buildable = new DiscoveryConfigList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}