package io.fabric8.openclustermanagement.api.model.discovery.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DiscoveryConfigBuilder extends DiscoveryConfigFluent<DiscoveryConfigBuilder> implements VisitableBuilder<DiscoveryConfig,DiscoveryConfigBuilder>{
  public DiscoveryConfigBuilder() {
    this(false);
  }
  public DiscoveryConfigBuilder(Boolean validationEnabled) {
    this(new DiscoveryConfig(), validationEnabled);
  }
  public DiscoveryConfigBuilder(DiscoveryConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public DiscoveryConfigBuilder(DiscoveryConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DiscoveryConfig(), validationEnabled);
  }
  public DiscoveryConfigBuilder(DiscoveryConfigFluent<?> fluent,DiscoveryConfig instance) {
    this(fluent, instance, false);
  }
  public DiscoveryConfigBuilder(DiscoveryConfigFluent<?> fluent,DiscoveryConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new DiscoveryConfig());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DiscoveryConfigBuilder(DiscoveryConfig instance) {
    this(instance,false);
  }
  public DiscoveryConfigBuilder(DiscoveryConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new DiscoveryConfig());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  DiscoveryConfigFluent<?> fluent;
  Boolean validationEnabled;
  public DiscoveryConfig build() {
    DiscoveryConfig buildable = new DiscoveryConfig(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  
}