package io.fabric8.openclustermanagement.api.model.discovery.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DiscoveredClusterListBuilder extends DiscoveredClusterListFluent<DiscoveredClusterListBuilder> implements VisitableBuilder<DiscoveredClusterList,DiscoveredClusterListBuilder>{
  public DiscoveredClusterListBuilder() {
    this(false);
  }
  public DiscoveredClusterListBuilder(Boolean validationEnabled) {
    this(new DiscoveredClusterList(), validationEnabled);
  }
  public DiscoveredClusterListBuilder(DiscoveredClusterListFluent<?> fluent) {
    this(fluent, false);
  }
  public DiscoveredClusterListBuilder(DiscoveredClusterListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DiscoveredClusterList(), validationEnabled);
  }
  public DiscoveredClusterListBuilder(DiscoveredClusterListFluent<?> fluent,DiscoveredClusterList instance) {
    this(fluent, instance, false);
  }
  public DiscoveredClusterListBuilder(DiscoveredClusterListFluent<?> fluent,DiscoveredClusterList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new DiscoveredClusterList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DiscoveredClusterListBuilder(DiscoveredClusterList instance) {
    this(instance,false);
  }
  public DiscoveredClusterListBuilder(DiscoveredClusterList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new DiscoveredClusterList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  DiscoveredClusterListFluent<?> fluent;
  Boolean validationEnabled;
  public DiscoveredClusterList build() {
    DiscoveredClusterList buildable = new DiscoveredClusterList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}