package io.fabric8.openclustermanagement.api.model.discovery.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DiscoveredClusterBuilder extends DiscoveredClusterFluent<DiscoveredClusterBuilder> implements VisitableBuilder<DiscoveredCluster,DiscoveredClusterBuilder>{
  public DiscoveredClusterBuilder() {
    this(false);
  }
  public DiscoveredClusterBuilder(Boolean validationEnabled) {
    this(new DiscoveredCluster(), validationEnabled);
  }
  public DiscoveredClusterBuilder(DiscoveredClusterFluent<?> fluent) {
    this(fluent, false);
  }
  public DiscoveredClusterBuilder(DiscoveredClusterFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DiscoveredCluster(), validationEnabled);
  }
  public DiscoveredClusterBuilder(DiscoveredClusterFluent<?> fluent,DiscoveredCluster instance) {
    this(fluent, instance, false);
  }
  public DiscoveredClusterBuilder(DiscoveredClusterFluent<?> fluent,DiscoveredCluster instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new DiscoveredCluster());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DiscoveredClusterBuilder(DiscoveredCluster instance) {
    this(instance,false);
  }
  public DiscoveredClusterBuilder(DiscoveredCluster instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new DiscoveredCluster());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  DiscoveredClusterFluent<?> fluent;
  Boolean validationEnabled;
  public DiscoveredCluster build() {
    DiscoveredCluster buildable = new DiscoveredCluster(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  
}