package io.fabric8.openclustermanagement.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OpenClusterManagementDiscoverySchemaBuilder extends OpenClusterManagementDiscoverySchemaFluent<OpenClusterManagementDiscoverySchemaBuilder> implements VisitableBuilder<OpenClusterManagementDiscoverySchema,OpenClusterManagementDiscoverySchemaBuilder>{
  public OpenClusterManagementDiscoverySchemaBuilder() {
    this(false);
  }
  public OpenClusterManagementDiscoverySchemaBuilder(Boolean validationEnabled) {
    this(new OpenClusterManagementDiscoverySchema(), validationEnabled);
  }
  public OpenClusterManagementDiscoverySchemaBuilder(OpenClusterManagementDiscoverySchemaFluent<?> fluent) {
    this(fluent, false);
  }
  public OpenClusterManagementDiscoverySchemaBuilder(OpenClusterManagementDiscoverySchemaFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OpenClusterManagementDiscoverySchema(), validationEnabled);
  }
  public OpenClusterManagementDiscoverySchemaBuilder(OpenClusterManagementDiscoverySchemaFluent<?> fluent,OpenClusterManagementDiscoverySchema instance) {
    this(fluent, instance, false);
  }
  public OpenClusterManagementDiscoverySchemaBuilder(OpenClusterManagementDiscoverySchemaFluent<?> fluent,OpenClusterManagementDiscoverySchema instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new OpenClusterManagementDiscoverySchema());

    if (instance != null) {
      fluent.withGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveredCluster(instance.getGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveredCluster());
      fluent.withGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveredClusterList(instance.getGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveredClusterList());
      fluent.withGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveredClusterSpec(instance.getGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveredClusterSpec());
      fluent.withGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveredClusterStatus(instance.getGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveredClusterStatus());
      fluent.withGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveryConfig(instance.getGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveryConfig());
      fluent.withGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveryConfigList(instance.getGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveryConfigList());
      fluent.withGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveryConfigSpec(instance.getGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveryConfigSpec());
      fluent.withGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveryConfigStatus(instance.getGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveryConfigStatus());
      fluent.withGithubComOpenClusterManagementDiscoveryApiV1alpha1Filter(instance.getGithubComOpenClusterManagementDiscoveryApiV1alpha1Filter());
      fluent.withGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveredCluster(instance.getGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveredCluster());
      fluent.withGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveredClusterList(instance.getGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveredClusterList());
      fluent.withGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveredClusterSpec(instance.getGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveredClusterSpec());
      fluent.withGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveredClusterStatus(instance.getGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveredClusterStatus());
      fluent.withGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveryConfig(instance.getGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveryConfig());
      fluent.withGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveryConfigList(instance.getGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveryConfigList());
      fluent.withGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveryConfigSpec(instance.getGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveryConfigSpec());
      fluent.withGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveryConfigStatus(instance.getGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveryConfigStatus());
      fluent.withGithubComOpenClusterManagementDiscoveryApiV1alpha1Filter(instance.getGithubComOpenClusterManagementDiscoveryApiV1alpha1Filter());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OpenClusterManagementDiscoverySchemaBuilder(OpenClusterManagementDiscoverySchema instance) {
    this(instance,false);
  }
  public OpenClusterManagementDiscoverySchemaBuilder(OpenClusterManagementDiscoverySchema instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new OpenClusterManagementDiscoverySchema());

    if (instance != null) {
      this.withGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveredCluster(instance.getGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveredCluster());
      this.withGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveredClusterList(instance.getGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveredClusterList());
      this.withGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveredClusterSpec(instance.getGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveredClusterSpec());
      this.withGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveredClusterStatus(instance.getGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveredClusterStatus());
      this.withGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveryConfig(instance.getGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveryConfig());
      this.withGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveryConfigList(instance.getGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveryConfigList());
      this.withGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveryConfigSpec(instance.getGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveryConfigSpec());
      this.withGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveryConfigStatus(instance.getGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveryConfigStatus());
      this.withGithubComOpenClusterManagementDiscoveryApiV1alpha1Filter(instance.getGithubComOpenClusterManagementDiscoveryApiV1alpha1Filter());
      this.withGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveredCluster(instance.getGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveredCluster());
      this.withGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveredClusterList(instance.getGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveredClusterList());
      this.withGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveredClusterSpec(instance.getGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveredClusterSpec());
      this.withGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveredClusterStatus(instance.getGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveredClusterStatus());
      this.withGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveryConfig(instance.getGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveryConfig());
      this.withGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveryConfigList(instance.getGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveryConfigList());
      this.withGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveryConfigSpec(instance.getGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveryConfigSpec());
      this.withGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveryConfigStatus(instance.getGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveryConfigStatus());
      this.withGithubComOpenClusterManagementDiscoveryApiV1alpha1Filter(instance.getGithubComOpenClusterManagementDiscoveryApiV1alpha1Filter());
    }
    this.validationEnabled = validationEnabled; 
  }
  OpenClusterManagementDiscoverySchemaFluent<?> fluent;
  Boolean validationEnabled;
  public OpenClusterManagementDiscoverySchema build() {
    OpenClusterManagementDiscoverySchema buildable = new OpenClusterManagementDiscoverySchema(fluent.buildGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveredCluster(),fluent.buildGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveredClusterList(),fluent.buildGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveredClusterSpec(),fluent.buildGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveredClusterStatus(),fluent.buildGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveryConfig(),fluent.buildGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveryConfigList(),fluent.buildGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveryConfigSpec(),fluent.buildGithubComOpenClusterManagementDiscoveryApiV1alpha1DiscoveryConfigStatus(),fluent.buildGithubComOpenClusterManagementDiscoveryApiV1alpha1Filter());
    return buildable;
  }
  
}