package io.fabric8.openclustermanagement.api.model.discovery.v1alpha1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class FilterFluentImpl<A extends FilterFluent<A>> extends BaseFluent<A> implements FilterFluent<A>{
  public FilterFluentImpl() {
  }
  public FilterFluentImpl(Filter instance) {
    this.withLastActive(instance.getLastActive()); 
    this.withOpenShiftVersions(instance.getOpenShiftVersions()); 
  }
  private Integer lastActive;
  private List<String> openShiftVersions = new ArrayList<String>();
  public Integer getLastActive() {
    return this.lastActive;
  }
  public A withLastActive(Integer lastActive) {
    this.lastActive=lastActive; return (A) this;
  }
  public Boolean hasLastActive() {
    return this.lastActive != null;
  }
  public A addToOpenShiftVersions(Integer index,String item) {
    if (this.openShiftVersions == null) {this.openShiftVersions = new ArrayList<String>();}
    this.openShiftVersions.add(index, item);
    return (A)this;
  }
  public A setToOpenShiftVersions(Integer index,String item) {
    if (this.openShiftVersions == null) {this.openShiftVersions = new ArrayList<String>();}
    this.openShiftVersions.set(index, item); return (A)this;
  }
  public A addToOpenShiftVersions(java.lang.String... items) {
    if (this.openShiftVersions == null) {this.openShiftVersions = new ArrayList<String>();}
    for (String item : items) {this.openShiftVersions.add(item);} return (A)this;
  }
  public A addAllToOpenShiftVersions(Collection<String> items) {
    if (this.openShiftVersions == null) {this.openShiftVersions = new ArrayList<String>();}
    for (String item : items) {this.openShiftVersions.add(item);} return (A)this;
  }
  public A removeFromOpenShiftVersions(java.lang.String... items) {
    for (String item : items) {if (this.openShiftVersions!= null){ this.openShiftVersions.remove(item);}} return (A)this;
  }
  public A removeAllFromOpenShiftVersions(Collection<String> items) {
    for (String item : items) {if (this.openShiftVersions!= null){ this.openShiftVersions.remove(item);}} return (A)this;
  }
  public List<String> getOpenShiftVersions() {
    return this.openShiftVersions;
  }
  public String getOpenShiftVersion(Integer index) {
    return this.openShiftVersions.get(index);
  }
  public String getFirstOpenShiftVersion() {
    return this.openShiftVersions.get(0);
  }
  public String getLastOpenShiftVersion() {
    return this.openShiftVersions.get(openShiftVersions.size() - 1);
  }
  public String getMatchingOpenShiftVersion(Predicate<String> predicate) {
    for (String item: openShiftVersions) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingOpenShiftVersion(Predicate<String> predicate) {
    for (String item: openShiftVersions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withOpenShiftVersions(List<String> openShiftVersions) {
    if (openShiftVersions != null) {this.openShiftVersions = new ArrayList(); for (String item : openShiftVersions){this.addToOpenShiftVersions(item);}} else { this.openShiftVersions = null;} return (A) this;
  }
  public A withOpenShiftVersions(java.lang.String... openShiftVersions) {
    if (this.openShiftVersions != null) {this.openShiftVersions.clear();}
    if (openShiftVersions != null) {for (String item :openShiftVersions){ this.addToOpenShiftVersions(item);}} return (A) this;
  }
  public Boolean hasOpenShiftVersions() {
    return openShiftVersions != null && !openShiftVersions.isEmpty();
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    FilterFluentImpl that = (FilterFluentImpl) o;
    if (lastActive != null ? !lastActive.equals(that.lastActive) :that.lastActive != null) return false;
    if (openShiftVersions != null ? !openShiftVersions.equals(that.openShiftVersions) :that.openShiftVersions != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(lastActive,  openShiftVersions,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (lastActive != null) { sb.append("lastActive:"); sb.append(lastActive + ","); }
    if (openShiftVersions != null && !openShiftVersions.isEmpty()) { sb.append("openShiftVersions:"); sb.append(openShiftVersions); }
    sb.append("}");
    return sb.toString();
  }
  
}