package io.fabric8.openclustermanagement.api.model.discovery.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DiscoveryConfigSpecBuilder extends DiscoveryConfigSpecFluentImpl<DiscoveryConfigSpecBuilder> implements VisitableBuilder<DiscoveryConfigSpec,DiscoveryConfigSpecBuilder>{
  public DiscoveryConfigSpecBuilder() {
    this(false);
  }
  public DiscoveryConfigSpecBuilder(Boolean validationEnabled) {
    this(new DiscoveryConfigSpec(), validationEnabled);
  }
  public DiscoveryConfigSpecBuilder(DiscoveryConfigSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public DiscoveryConfigSpecBuilder(DiscoveryConfigSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DiscoveryConfigSpec(), validationEnabled);
  }
  public DiscoveryConfigSpecBuilder(DiscoveryConfigSpecFluent<?> fluent,DiscoveryConfigSpec instance) {
    this(fluent, instance, false);
  }
  public DiscoveryConfigSpecBuilder(DiscoveryConfigSpecFluent<?> fluent,DiscoveryConfigSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCredential(instance.getCredential()); 
    fluent.withFilters(instance.getFilters()); 
    this.validationEnabled = validationEnabled; 
  }
  public DiscoveryConfigSpecBuilder(DiscoveryConfigSpec instance) {
    this(instance,false);
  }
  public DiscoveryConfigSpecBuilder(DiscoveryConfigSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withCredential(instance.getCredential()); 
    this.withFilters(instance.getFilters()); 
    this.validationEnabled = validationEnabled; 
  }
  DiscoveryConfigSpecFluent<?> fluent;
  Boolean validationEnabled;
  public DiscoveryConfigSpec build() {
    DiscoveryConfigSpec buildable = new DiscoveryConfigSpec(fluent.getCredential(),fluent.getFilters());
    return buildable;
  }
  
}