package io.fabric8.openclustermanagement.api.model.discovery.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class DiscoveredClusterSpecFluentImpl<A extends DiscoveredClusterSpecFluent<A>> extends BaseFluent<A> implements DiscoveredClusterSpecFluent<A>{
  public DiscoveredClusterSpecFluentImpl() {
  }
  public DiscoveredClusterSpecFluentImpl(DiscoveredClusterSpec instance) {
    this.withActivityTimestamp(instance.getActivityTimestamp()); 
    this.withApiUrl(instance.getApiUrl()); 
    this.withCloudProvider(instance.getCloudProvider()); 
    this.withConsole(instance.getConsole()); 
    this.withCreationTimestamp(instance.getCreationTimestamp()); 
    this.withCredential(instance.getCredential()); 
    this.withDisplayName(instance.getDisplayName()); 
    this.withIsManagedCluster(instance.getIsManagedCluster()); 
    this.withName(instance.getName()); 
    this.withOpenshiftVersion(instance.getOpenshiftVersion()); 
    this.withStatus(instance.getStatus()); 
    this.withType(instance.getType()); 
  }
  private String activityTimestamp;
  private String apiUrl;
  private String cloudProvider;
  private String console;
  private String creationTimestamp;
  private ObjectReferenceBuilder credential;
  private String displayName;
  private Boolean isManagedCluster;
  private String name;
  private String openshiftVersion;
  private String status;
  private String type;
  public String getActivityTimestamp() {
    return this.activityTimestamp;
  }
  public A withActivityTimestamp(String activityTimestamp) {
    this.activityTimestamp=activityTimestamp; return (A) this;
  }
  public Boolean hasActivityTimestamp() {
    return this.activityTimestamp != null;
  }
  public String getApiUrl() {
    return this.apiUrl;
  }
  public A withApiUrl(String apiUrl) {
    this.apiUrl=apiUrl; return (A) this;
  }
  public Boolean hasApiUrl() {
    return this.apiUrl != null;
  }
  public String getCloudProvider() {
    return this.cloudProvider;
  }
  public A withCloudProvider(String cloudProvider) {
    this.cloudProvider=cloudProvider; return (A) this;
  }
  public Boolean hasCloudProvider() {
    return this.cloudProvider != null;
  }
  public String getConsole() {
    return this.console;
  }
  public A withConsole(String console) {
    this.console=console; return (A) this;
  }
  public Boolean hasConsole() {
    return this.console != null;
  }
  public String getCreationTimestamp() {
    return this.creationTimestamp;
  }
  public A withCreationTimestamp(String creationTimestamp) {
    this.creationTimestamp=creationTimestamp; return (A) this;
  }
  public Boolean hasCreationTimestamp() {
    return this.creationTimestamp != null;
  }
  
  /**
   * This method has been deprecated, please use method buildCredential instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getCredential() {
    return this.credential!=null ?this.credential.build():null;
  }
  public ObjectReference buildCredential() {
    return this.credential!=null ?this.credential.build():null;
  }
  public A withCredential(ObjectReference credential) {
    _visitables.get("credential").remove(this.credential);
    if (credential!=null){ this.credential= new ObjectReferenceBuilder(credential); _visitables.get("credential").add(this.credential);} else { this.credential = null; _visitables.get("credential").remove(this.credential); } return (A) this;
  }
  public Boolean hasCredential() {
    return this.credential != null;
  }
  public DiscoveredClusterSpecFluent.CredentialNested<A> withNewCredential() {
    return new DiscoveredClusterSpecFluentImpl.CredentialNestedImpl();
  }
  public DiscoveredClusterSpecFluent.CredentialNested<A> withNewCredentialLike(ObjectReference item) {
    return new DiscoveredClusterSpecFluentImpl.CredentialNestedImpl(item);
  }
  public DiscoveredClusterSpecFluent.CredentialNested<A> editCredential() {
    return withNewCredentialLike(getCredential());
  }
  public DiscoveredClusterSpecFluent.CredentialNested<A> editOrNewCredential() {
    return withNewCredentialLike(getCredential() != null ? getCredential(): new ObjectReferenceBuilder().build());
  }
  public DiscoveredClusterSpecFluent.CredentialNested<A> editOrNewCredentialLike(ObjectReference item) {
    return withNewCredentialLike(getCredential() != null ? getCredential(): item);
  }
  public String getDisplayName() {
    return this.displayName;
  }
  public A withDisplayName(String displayName) {
    this.displayName=displayName; return (A) this;
  }
  public Boolean hasDisplayName() {
    return this.displayName != null;
  }
  public Boolean getIsManagedCluster() {
    return this.isManagedCluster;
  }
  public A withIsManagedCluster(Boolean isManagedCluster) {
    this.isManagedCluster=isManagedCluster; return (A) this;
  }
  public Boolean hasIsManagedCluster() {
    return this.isManagedCluster != null;
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  public String getOpenshiftVersion() {
    return this.openshiftVersion;
  }
  public A withOpenshiftVersion(String openshiftVersion) {
    this.openshiftVersion=openshiftVersion; return (A) this;
  }
  public Boolean hasOpenshiftVersion() {
    return this.openshiftVersion != null;
  }
  public String getStatus() {
    return this.status;
  }
  public A withStatus(String status) {
    this.status=status; return (A) this;
  }
  public Boolean hasStatus() {
    return this.status != null;
  }
  public String getType() {
    return this.type;
  }
  public A withType(String type) {
    this.type=type; return (A) this;
  }
  public Boolean hasType() {
    return this.type != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DiscoveredClusterSpecFluentImpl that = (DiscoveredClusterSpecFluentImpl) o;
    if (activityTimestamp != null ? !activityTimestamp.equals(that.activityTimestamp) :that.activityTimestamp != null) return false;
    if (apiUrl != null ? !apiUrl.equals(that.apiUrl) :that.apiUrl != null) return false;
    if (cloudProvider != null ? !cloudProvider.equals(that.cloudProvider) :that.cloudProvider != null) return false;
    if (console != null ? !console.equals(that.console) :that.console != null) return false;
    if (creationTimestamp != null ? !creationTimestamp.equals(that.creationTimestamp) :that.creationTimestamp != null) return false;
    if (credential != null ? !credential.equals(that.credential) :that.credential != null) return false;
    if (displayName != null ? !displayName.equals(that.displayName) :that.displayName != null) return false;
    if (isManagedCluster != null ? !isManagedCluster.equals(that.isManagedCluster) :that.isManagedCluster != null) return false;
    if (name != null ? !name.equals(that.name) :that.name != null) return false;
    if (openshiftVersion != null ? !openshiftVersion.equals(that.openshiftVersion) :that.openshiftVersion != null) return false;
    if (status != null ? !status.equals(that.status) :that.status != null) return false;
    if (type != null ? !type.equals(that.type) :that.type != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(activityTimestamp,  apiUrl,  cloudProvider,  console,  creationTimestamp,  credential,  displayName,  isManagedCluster,  name,  openshiftVersion,  status,  type,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (activityTimestamp != null) { sb.append("activityTimestamp:"); sb.append(activityTimestamp + ","); }
    if (apiUrl != null) { sb.append("apiUrl:"); sb.append(apiUrl + ","); }
    if (cloudProvider != null) { sb.append("cloudProvider:"); sb.append(cloudProvider + ","); }
    if (console != null) { sb.append("console:"); sb.append(console + ","); }
    if (creationTimestamp != null) { sb.append("creationTimestamp:"); sb.append(creationTimestamp + ","); }
    if (credential != null) { sb.append("credential:"); sb.append(credential + ","); }
    if (displayName != null) { sb.append("displayName:"); sb.append(displayName + ","); }
    if (isManagedCluster != null) { sb.append("isManagedCluster:"); sb.append(isManagedCluster + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (openshiftVersion != null) { sb.append("openshiftVersion:"); sb.append(openshiftVersion + ","); }
    if (status != null) { sb.append("status:"); sb.append(status + ","); }
    if (type != null) { sb.append("type:"); sb.append(type); }
    sb.append("}");
    return sb.toString();
  }
  public A withIsManagedCluster() {
    return withIsManagedCluster(true);
  }
  class CredentialNestedImpl<N> extends ObjectReferenceFluentImpl<DiscoveredClusterSpecFluent.CredentialNested<N>> implements DiscoveredClusterSpecFluent.CredentialNested<N>,Nested<N>{
    CredentialNestedImpl(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    CredentialNestedImpl() {
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) DiscoveredClusterSpecFluentImpl.this.withCredential(builder.build());
    }
    public N endCredential() {
      return and();
    }
    
  }
  
}