/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.discovery.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.DiscoveryConfig;
import io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.DiscoveryConfigFluent;
import io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.DiscoveryConfigSpec;
import io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.DiscoveryConfigSpecBuilder;
import io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.DiscoveryConfigSpecFluentImpl;
import io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.DiscoveryConfigStatus;
import io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.DiscoveryConfigStatusBuilder;
import io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.DiscoveryConfigStatusFluentImpl;
import java.util.Objects;

public class DiscoveryConfigFluentImpl<A extends DiscoveryConfigFluent<A>>
extends BaseFluent<A>
implements DiscoveryConfigFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private DiscoveryConfigSpecBuilder spec;
    private DiscoveryConfigStatusBuilder status;

    public DiscoveryConfigFluentImpl() {
    }

    public DiscoveryConfigFluentImpl(DiscoveryConfig instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get((Object)"metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public DiscoveryConfigFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public DiscoveryConfigFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public DiscoveryConfigFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public DiscoveryConfigFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public DiscoveryConfigFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public DiscoveryConfigSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public DiscoveryConfigSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(DiscoveryConfigSpec spec) {
        this._visitables.get((Object)"spec").remove(this.spec);
        if (spec != null) {
            this.spec = new DiscoveryConfigSpecBuilder(spec);
            this._visitables.get((Object)"spec").add(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public DiscoveryConfigFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public DiscoveryConfigFluent.SpecNested<A> withNewSpecLike(DiscoveryConfigSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public DiscoveryConfigFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public DiscoveryConfigFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new DiscoveryConfigSpecBuilder().build());
    }

    @Override
    public DiscoveryConfigFluent.SpecNested<A> editOrNewSpecLike(DiscoveryConfigSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public DiscoveryConfigStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public DiscoveryConfigStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(DiscoveryConfigStatus status) {
        this._visitables.get((Object)"status").remove(this.status);
        if (status != null) {
            this.status = new DiscoveryConfigStatusBuilder(status);
            this._visitables.get((Object)"status").add(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public DiscoveryConfigFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public DiscoveryConfigFluent.StatusNested<A> withNewStatusLike(DiscoveryConfigStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public DiscoveryConfigFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public DiscoveryConfigFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new DiscoveryConfigStatusBuilder().build());
    }

    @Override
    public DiscoveryConfigFluent.StatusNested<A> editOrNewStatusLike(DiscoveryConfigStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiscoveryConfigFluentImpl that = (DiscoveryConfigFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals((Object)that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, this.status, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.spec != null) {
            sb.append("spec:");
            sb.append(this.spec + ",");
        }
        if (this.status != null) {
            sb.append("status:");
            sb.append(this.status);
        }
        sb.append("}");
        return sb.toString();
    }

    class StatusNestedImpl<N>
    extends DiscoveryConfigStatusFluentImpl<DiscoveryConfigFluent.StatusNested<N>>
    implements DiscoveryConfigFluent.StatusNested<N>,
    Nested<N> {
        DiscoveryConfigStatusBuilder builder;

        StatusNestedImpl(DiscoveryConfigStatus item) {
            this.builder = new DiscoveryConfigStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new DiscoveryConfigStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)DiscoveryConfigFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    class SpecNestedImpl<N>
    extends DiscoveryConfigSpecFluentImpl<DiscoveryConfigFluent.SpecNested<N>>
    implements DiscoveryConfigFluent.SpecNested<N>,
    Nested<N> {
        DiscoveryConfigSpecBuilder builder;

        SpecNestedImpl(DiscoveryConfigSpec item) {
            this.builder = new DiscoveryConfigSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new DiscoveryConfigSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)DiscoveryConfigFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<DiscoveryConfigFluent.MetadataNested<N>>
    implements DiscoveryConfigFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this);
        }

        @Override
        public N and() {
            return (N)DiscoveryConfigFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

