package io.fabric8.openclustermanagement.api.model.discovery.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DiscoveryConfigBuilder extends DiscoveryConfigFluentImpl<DiscoveryConfigBuilder> implements VisitableBuilder<DiscoveryConfig,io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.DiscoveryConfigBuilder>{
  public DiscoveryConfigBuilder() {
    this(false);
  }
  public DiscoveryConfigBuilder(Boolean validationEnabled) {
    this(new DiscoveryConfig(), validationEnabled);
  }
  public DiscoveryConfigBuilder(DiscoveryConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public DiscoveryConfigBuilder(io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.DiscoveryConfigFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new DiscoveryConfig(), validationEnabled);
  }
  public DiscoveryConfigBuilder(io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.DiscoveryConfigFluent<?> fluent,io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.DiscoveryConfig instance) {
    this(fluent, instance, false);
  }
  public DiscoveryConfigBuilder(io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.DiscoveryConfigFluent<?> fluent,io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.DiscoveryConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public DiscoveryConfigBuilder(io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.DiscoveryConfig instance) {
    this(instance,false);
  }
  public DiscoveryConfigBuilder(io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.DiscoveryConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.DiscoveryConfigFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.DiscoveryConfig build() {
    DiscoveryConfig buildable = new DiscoveryConfig(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}