package io.fabric8.openclustermanagement.api.model.discovery.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DiscoveredClusterSpecBuilder extends DiscoveredClusterSpecFluentImpl<DiscoveredClusterSpecBuilder> implements VisitableBuilder<DiscoveredClusterSpec,io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.DiscoveredClusterSpecBuilder>{
  public DiscoveredClusterSpecBuilder() {
    this(false);
  }
  public DiscoveredClusterSpecBuilder(Boolean validationEnabled) {
    this(new DiscoveredClusterSpec(), validationEnabled);
  }
  public DiscoveredClusterSpecBuilder(io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.DiscoveredClusterSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public DiscoveredClusterSpecBuilder(io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.DiscoveredClusterSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new DiscoveredClusterSpec(), validationEnabled);
  }
  public DiscoveredClusterSpecBuilder(io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.DiscoveredClusterSpecFluent<?> fluent,io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.DiscoveredClusterSpec instance) {
    this(fluent, instance, false);
  }
  public DiscoveredClusterSpecBuilder(io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.DiscoveredClusterSpecFluent<?> fluent,io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.DiscoveredClusterSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withActivityTimestamp(instance.getActivityTimestamp()); 
    fluent.withApiUrl(instance.getApiUrl()); 
    fluent.withCloudProvider(instance.getCloudProvider()); 
    fluent.withConsole(instance.getConsole()); 
    fluent.withCreationTimestamp(instance.getCreationTimestamp()); 
    fluent.withCredential(instance.getCredential()); 
    fluent.withDisplayName(instance.getDisplayName()); 
    fluent.withIsManagedCluster(instance.getIsManagedCluster()); 
    fluent.withName(instance.getName()); 
    fluent.withOpenshiftVersion(instance.getOpenshiftVersion()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withType(instance.getType()); 
    this.validationEnabled = validationEnabled; 
  }
  public DiscoveredClusterSpecBuilder(io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.DiscoveredClusterSpec instance) {
    this(instance,false);
  }
  public DiscoveredClusterSpecBuilder(io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.DiscoveredClusterSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withActivityTimestamp(instance.getActivityTimestamp()); 
    this.withApiUrl(instance.getApiUrl()); 
    this.withCloudProvider(instance.getCloudProvider()); 
    this.withConsole(instance.getConsole()); 
    this.withCreationTimestamp(instance.getCreationTimestamp()); 
    this.withCredential(instance.getCredential()); 
    this.withDisplayName(instance.getDisplayName()); 
    this.withIsManagedCluster(instance.getIsManagedCluster()); 
    this.withName(instance.getName()); 
    this.withOpenshiftVersion(instance.getOpenshiftVersion()); 
    this.withStatus(instance.getStatus()); 
    this.withType(instance.getType()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.DiscoveredClusterSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.DiscoveredClusterSpec build() {
    DiscoveredClusterSpec buildable = new DiscoveredClusterSpec(fluent.getActivityTimestamp(),fluent.getApiUrl(),fluent.getCloudProvider(),fluent.getConsole(),fluent.getCreationTimestamp(),fluent.getCredential(),fluent.getDisplayName(),fluent.getIsManagedCluster(),fluent.getName(),fluent.getOpenshiftVersion(),fluent.getStatus(),fluent.getType());
    return buildable;
  }
  
}