package io.fabric8.openclustermanagement.api.model.discovery.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DiscoveredClusterBuilder extends DiscoveredClusterFluentImpl<DiscoveredClusterBuilder> implements VisitableBuilder<io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.DiscoveredCluster,io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.DiscoveredClusterBuilder>{
  public DiscoveredClusterBuilder() {
    this(false);
  }
  public DiscoveredClusterBuilder(Boolean validationEnabled) {
    this(new DiscoveredCluster(), validationEnabled);
  }
  public DiscoveredClusterBuilder(DiscoveredClusterFluent<?> fluent) {
    this(fluent, false);
  }
  public DiscoveredClusterBuilder(io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.DiscoveredClusterFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new DiscoveredCluster(), validationEnabled);
  }
  public DiscoveredClusterBuilder(io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.DiscoveredClusterFluent<?> fluent,io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.DiscoveredCluster instance) {
    this(fluent, instance, false);
  }
  public DiscoveredClusterBuilder(io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.DiscoveredClusterFluent<?> fluent,io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.DiscoveredCluster instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public DiscoveredClusterBuilder(io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.DiscoveredCluster instance) {
    this(instance,false);
  }
  public DiscoveredClusterBuilder(io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.DiscoveredCluster instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.DiscoveredClusterFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.DiscoveredCluster build() {
    DiscoveredCluster buildable = new DiscoveredCluster(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}