/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.discovery.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.Filter;
import io.fabric8.openclustermanagement.api.model.discovery.v1alpha1.FilterFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class FilterFluentImpl<A extends FilterFluent<A>>
extends BaseFluent<A>
implements FilterFluent<A> {
    private Integer lastActive;
    private List<String> openShiftVersions;

    public FilterFluentImpl() {
    }

    public FilterFluentImpl(Filter instance) {
        this.withLastActive(instance.getLastActive());
        this.withOpenShiftVersions(instance.getOpenShiftVersions());
    }

    @Override
    public Integer getLastActive() {
        return this.lastActive;
    }

    @Override
    public A withLastActive(Integer lastActive) {
        this.lastActive = lastActive;
        return (A)this;
    }

    @Override
    public Boolean hasLastActive() {
        return this.lastActive != null;
    }

    @Override
    public A addToOpenShiftVersions(Integer index, String item) {
        if (this.openShiftVersions == null) {
            this.openShiftVersions = new ArrayList<String>();
        }
        this.openShiftVersions.add(index, item);
        return (A)this;
    }

    @Override
    public A setToOpenShiftVersions(Integer index, String item) {
        if (this.openShiftVersions == null) {
            this.openShiftVersions = new ArrayList<String>();
        }
        this.openShiftVersions.set(index, item);
        return (A)this;
    }

    @Override
    public A addToOpenShiftVersions(String ... items) {
        if (this.openShiftVersions == null) {
            this.openShiftVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.openShiftVersions.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToOpenShiftVersions(Collection<String> items) {
        if (this.openShiftVersions == null) {
            this.openShiftVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.openShiftVersions.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromOpenShiftVersions(String ... items) {
        for (String item : items) {
            if (this.openShiftVersions == null) continue;
            this.openShiftVersions.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromOpenShiftVersions(Collection<String> items) {
        for (String item : items) {
            if (this.openShiftVersions == null) continue;
            this.openShiftVersions.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getOpenShiftVersions() {
        return this.openShiftVersions;
    }

    @Override
    public String getOpenShiftVersion(Integer index) {
        return this.openShiftVersions.get(index);
    }

    @Override
    public String getFirstOpenShiftVersion() {
        return this.openShiftVersions.get(0);
    }

    @Override
    public String getLastOpenShiftVersion() {
        return this.openShiftVersions.get(this.openShiftVersions.size() - 1);
    }

    @Override
    public String getMatchingOpenShiftVersion(Predicate<String> predicate) {
        for (String item : this.openShiftVersions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingOpenShiftVersion(Predicate<String> predicate) {
        for (String item : this.openShiftVersions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withOpenShiftVersions(List<String> openShiftVersions) {
        if (openShiftVersions != null) {
            this.openShiftVersions = new ArrayList<String>();
            for (String item : openShiftVersions) {
                this.addToOpenShiftVersions(item);
            }
        } else {
            this.openShiftVersions = null;
        }
        return (A)this;
    }

    @Override
    public A withOpenShiftVersions(String ... openShiftVersions) {
        if (this.openShiftVersions != null) {
            this.openShiftVersions.clear();
        }
        if (openShiftVersions != null) {
            for (String item : openShiftVersions) {
                this.addToOpenShiftVersions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasOpenShiftVersions() {
        return this.openShiftVersions != null && !this.openShiftVersions.isEmpty();
    }

    @Override
    public A addNewOpenShiftVersion(String arg0) {
        return this.addToOpenShiftVersions(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterFluentImpl that = (FilterFluentImpl)o;
        if (this.lastActive != null ? !this.lastActive.equals(that.lastActive) : that.lastActive != null) {
            return false;
        }
        return !(this.openShiftVersions != null ? !this.openShiftVersions.equals(that.openShiftVersions) : that.openShiftVersions != null);
    }

    public int hashCode() {
        return Objects.hash(this.lastActive, this.openShiftVersions, super.hashCode());
    }
}

