/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.cluster.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.PrioritizerConfig;
import io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.PrioritizerConfigBuilder;
import io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.PrioritizerConfigFluent;
import io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.PrioritizerPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class PrioritizerPolicyFluent<A extends PrioritizerPolicyFluent<A>>
extends BaseFluent<A> {
    private ArrayList<PrioritizerConfigBuilder> configurations = new ArrayList();
    private String mode;

    public PrioritizerPolicyFluent() {
    }

    public PrioritizerPolicyFluent(PrioritizerPolicy instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PrioritizerPolicy instance) {
        PrioritizerPolicy prioritizerPolicy = instance = instance != null ? instance : new PrioritizerPolicy();
        if (instance != null) {
            this.withConfigurations(instance.getConfigurations());
            this.withMode(instance.getMode());
            this.withConfigurations(instance.getConfigurations());
            this.withMode(instance.getMode());
        }
    }

    public A addToConfigurations(int index, PrioritizerConfig item) {
        if (this.configurations == null) {
            this.configurations = new ArrayList();
        }
        PrioritizerConfigBuilder builder = new PrioritizerConfigBuilder(item);
        if (index < 0 || index >= this.configurations.size()) {
            this._visitables.get((Object)"configurations").add(builder);
            this.configurations.add(builder);
        } else {
            this._visitables.get((Object)"configurations").add(index, builder);
            this.configurations.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToConfigurations(int index, PrioritizerConfig item) {
        if (this.configurations == null) {
            this.configurations = new ArrayList();
        }
        PrioritizerConfigBuilder builder = new PrioritizerConfigBuilder(item);
        if (index < 0 || index >= this.configurations.size()) {
            this._visitables.get((Object)"configurations").add(builder);
            this.configurations.add(builder);
        } else {
            this._visitables.get((Object)"configurations").set(index, builder);
            this.configurations.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToConfigurations(PrioritizerConfig ... items) {
        if (this.configurations == null) {
            this.configurations = new ArrayList();
        }
        for (PrioritizerConfig item : items) {
            PrioritizerConfigBuilder builder = new PrioritizerConfigBuilder(item);
            this._visitables.get((Object)"configurations").add(builder);
            this.configurations.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToConfigurations(Collection<PrioritizerConfig> items) {
        if (this.configurations == null) {
            this.configurations = new ArrayList();
        }
        for (PrioritizerConfig item : items) {
            PrioritizerConfigBuilder builder = new PrioritizerConfigBuilder(item);
            this._visitables.get((Object)"configurations").add(builder);
            this.configurations.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromConfigurations(PrioritizerConfig ... items) {
        if (this.configurations == null) {
            return (A)((Object)this);
        }
        for (PrioritizerConfig item : items) {
            PrioritizerConfigBuilder builder = new PrioritizerConfigBuilder(item);
            this._visitables.get((Object)"configurations").remove((Object)builder);
            this.configurations.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConfigurations(Collection<PrioritizerConfig> items) {
        if (this.configurations == null) {
            return (A)((Object)this);
        }
        for (PrioritizerConfig item : items) {
            PrioritizerConfigBuilder builder = new PrioritizerConfigBuilder(item);
            this._visitables.get((Object)"configurations").remove((Object)builder);
            this.configurations.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromConfigurations(Predicate<PrioritizerConfigBuilder> predicate) {
        if (this.configurations == null) {
            return (A)((Object)this);
        }
        Iterator<PrioritizerConfigBuilder> each = this.configurations.iterator();
        List visitables = this._visitables.get((Object)"configurations");
        while (each.hasNext()) {
            PrioritizerConfigBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<PrioritizerConfig> buildConfigurations() {
        return this.configurations != null ? PrioritizerPolicyFluent.build(this.configurations) : null;
    }

    public PrioritizerConfig buildConfiguration(int index) {
        return this.configurations.get(index).build();
    }

    public PrioritizerConfig buildFirstConfiguration() {
        return this.configurations.get(0).build();
    }

    public PrioritizerConfig buildLastConfiguration() {
        return this.configurations.get(this.configurations.size() - 1).build();
    }

    public PrioritizerConfig buildMatchingConfiguration(Predicate<PrioritizerConfigBuilder> predicate) {
        for (PrioritizerConfigBuilder item : this.configurations) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingConfiguration(Predicate<PrioritizerConfigBuilder> predicate) {
        for (PrioritizerConfigBuilder item : this.configurations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConfigurations(List<PrioritizerConfig> configurations) {
        if (this.configurations != null) {
            this._visitables.get((Object)"configurations").clear();
        }
        if (configurations != null) {
            this.configurations = new ArrayList();
            for (PrioritizerConfig item : configurations) {
                this.addToConfigurations(item);
            }
        } else {
            this.configurations = null;
        }
        return (A)((Object)this);
    }

    public A withConfigurations(PrioritizerConfig ... configurations) {
        if (this.configurations != null) {
            this.configurations.clear();
            this._visitables.remove((Object)"configurations");
        }
        if (configurations != null) {
            for (PrioritizerConfig item : configurations) {
                this.addToConfigurations(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConfigurations() {
        return this.configurations != null && !this.configurations.isEmpty();
    }

    public A addNewConfiguration(String name, Integer weight) {
        return this.addToConfigurations(new PrioritizerConfig(name, weight));
    }

    public ConfigurationsNested<A> addNewConfiguration() {
        return new ConfigurationsNested(-1, null);
    }

    public ConfigurationsNested<A> addNewConfigurationLike(PrioritizerConfig item) {
        return new ConfigurationsNested(-1, item);
    }

    public ConfigurationsNested<A> setNewConfigurationLike(int index, PrioritizerConfig item) {
        return new ConfigurationsNested(index, item);
    }

    public ConfigurationsNested<A> editConfiguration(int index) {
        if (this.configurations.size() <= index) {
            throw new RuntimeException("Can't edit configurations. Index exceeds size.");
        }
        return this.setNewConfigurationLike(index, this.buildConfiguration(index));
    }

    public ConfigurationsNested<A> editFirstConfiguration() {
        if (this.configurations.size() == 0) {
            throw new RuntimeException("Can't edit first configurations. The list is empty.");
        }
        return this.setNewConfigurationLike(0, this.buildConfiguration(0));
    }

    public ConfigurationsNested<A> editLastConfiguration() {
        int index = this.configurations.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last configurations. The list is empty.");
        }
        return this.setNewConfigurationLike(index, this.buildConfiguration(index));
    }

    public ConfigurationsNested<A> editMatchingConfiguration(Predicate<PrioritizerConfigBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.configurations.size(); ++i) {
            if (!predicate.test(this.configurations.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching configurations. No match found.");
        }
        return this.setNewConfigurationLike(index, this.buildConfiguration(index));
    }

    public String getMode() {
        return this.mode;
    }

    public A withMode(String mode) {
        this.mode = mode;
        return (A)((Object)this);
    }

    public boolean hasMode() {
        return this.mode != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PrioritizerPolicyFluent that = (PrioritizerPolicyFluent)((Object)o);
        if (!Objects.equals(this.configurations, that.configurations)) {
            return false;
        }
        return Objects.equals(this.mode, that.mode);
    }

    public int hashCode() {
        return Objects.hash(this.configurations, this.mode, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configurations != null && !this.configurations.isEmpty()) {
            sb.append("configurations:");
            sb.append(this.configurations + ",");
        }
        if (this.mode != null) {
            sb.append("mode:");
            sb.append(this.mode);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ConfigurationsNested<N>
    extends PrioritizerConfigFluent<ConfigurationsNested<N>>
    implements Nested<N> {
        PrioritizerConfigBuilder builder;
        int index;

        ConfigurationsNested(int index, PrioritizerConfig item) {
            this.index = index;
            this.builder = new PrioritizerConfigBuilder(this, item);
        }

        public N and() {
            return (N)PrioritizerPolicyFluent.this.setToConfigurations(this.index, this.builder.build());
        }

        public N endConfiguration() {
            return this.and();
        }
    }
}

