package io.fabric8.openclustermanagement.api.model.cluster.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PrioritizerPolicyFluent<A extends PrioritizerPolicyFluent<A>> extends BaseFluent<A>{
  public PrioritizerPolicyFluent() {
  }
  
  public PrioritizerPolicyFluent(PrioritizerPolicy instance) {
    this.copyInstance(instance);
  }
  private ArrayList<PrioritizerConfigBuilder> configurations = new ArrayList<PrioritizerConfigBuilder>();
  private String mode;
  
  protected void copyInstance(PrioritizerPolicy instance) {
    instance = (instance != null ? instance : new PrioritizerPolicy());
  
    if (instance != null) {
        this.withConfigurations(instance.getConfigurations());
        this.withMode(instance.getMode());
        this.withConfigurations(instance.getConfigurations());
        this.withMode(instance.getMode());
      }
  }
  
  public A addToConfigurations(int index,PrioritizerConfig item) {
    if (this.configurations == null) {this.configurations = new ArrayList<PrioritizerConfigBuilder>();}
    PrioritizerConfigBuilder builder = new PrioritizerConfigBuilder(item);
    if (index < 0 || index >= configurations.size()) { _visitables.get("configurations").add(builder); configurations.add(builder); } else { _visitables.get("configurations").add(index, builder); configurations.add(index, builder);}
    return (A)this;
  }
  
  public A setToConfigurations(int index,PrioritizerConfig item) {
    if (this.configurations == null) {this.configurations = new ArrayList<PrioritizerConfigBuilder>();}
    PrioritizerConfigBuilder builder = new PrioritizerConfigBuilder(item);
    if (index < 0 || index >= configurations.size()) { _visitables.get("configurations").add(builder); configurations.add(builder); } else { _visitables.get("configurations").set(index, builder); configurations.set(index, builder);}
    return (A)this;
  }
  
  public A addToConfigurations(io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.PrioritizerConfig... items) {
    if (this.configurations == null) {this.configurations = new ArrayList<PrioritizerConfigBuilder>();}
    for (PrioritizerConfig item : items) {PrioritizerConfigBuilder builder = new PrioritizerConfigBuilder(item);_visitables.get("configurations").add(builder);this.configurations.add(builder);} return (A)this;
  }
  
  public A addAllToConfigurations(Collection<PrioritizerConfig> items) {
    if (this.configurations == null) {this.configurations = new ArrayList<PrioritizerConfigBuilder>();}
    for (PrioritizerConfig item : items) {PrioritizerConfigBuilder builder = new PrioritizerConfigBuilder(item);_visitables.get("configurations").add(builder);this.configurations.add(builder);} return (A)this;
  }
  
  public A removeFromConfigurations(io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.PrioritizerConfig... items) {
    if (this.configurations == null) return (A)this;
    for (PrioritizerConfig item : items) {PrioritizerConfigBuilder builder = new PrioritizerConfigBuilder(item);_visitables.get("configurations").remove(builder); this.configurations.remove(builder);} return (A)this;
  }
  
  public A removeAllFromConfigurations(Collection<PrioritizerConfig> items) {
    if (this.configurations == null) return (A)this;
    for (PrioritizerConfig item : items) {PrioritizerConfigBuilder builder = new PrioritizerConfigBuilder(item);_visitables.get("configurations").remove(builder); this.configurations.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromConfigurations(Predicate<PrioritizerConfigBuilder> predicate) {
    if (configurations == null) return (A) this;
    final Iterator<PrioritizerConfigBuilder> each = configurations.iterator();
    final List visitables = _visitables.get("configurations");
    while (each.hasNext()) {
      PrioritizerConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<PrioritizerConfig> buildConfigurations() {
    return configurations != null ? build(configurations) : null;
  }
  
  public PrioritizerConfig buildConfiguration(int index) {
    return this.configurations.get(index).build();
  }
  
  public PrioritizerConfig buildFirstConfiguration() {
    return this.configurations.get(0).build();
  }
  
  public PrioritizerConfig buildLastConfiguration() {
    return this.configurations.get(configurations.size() - 1).build();
  }
  
  public PrioritizerConfig buildMatchingConfiguration(Predicate<PrioritizerConfigBuilder> predicate) {
    for (PrioritizerConfigBuilder item: configurations) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingConfiguration(Predicate<PrioritizerConfigBuilder> predicate) {
    for (PrioritizerConfigBuilder item: configurations) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withConfigurations(List<PrioritizerConfig> configurations) {
    if (this.configurations != null) { _visitables.get("configurations").clear();}
    if (configurations != null) {this.configurations = new ArrayList(); for (PrioritizerConfig item : configurations){this.addToConfigurations(item);}} else { this.configurations = null;} return (A) this;
  }
  
  public A withConfigurations(io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.PrioritizerConfig... configurations) {
    if (this.configurations != null) {this.configurations.clear(); _visitables.remove("configurations"); }
    if (configurations != null) {for (PrioritizerConfig item :configurations){ this.addToConfigurations(item);}} return (A) this;
  }
  
  public boolean hasConfigurations() {
    return configurations != null && !configurations.isEmpty();
  }
  
  public A addNewConfiguration(String name,Integer weight) {
    return (A)addToConfigurations(new PrioritizerConfig(name, weight));
  }
  
  public ConfigurationsNested<A> addNewConfiguration() {
    return new ConfigurationsNested(-1, null);
  }
  
  public ConfigurationsNested<A> addNewConfigurationLike(PrioritizerConfig item) {
    return new ConfigurationsNested(-1, item);
  }
  
  public ConfigurationsNested<A> setNewConfigurationLike(int index,PrioritizerConfig item) {
    return new ConfigurationsNested(index, item);
  }
  
  public ConfigurationsNested<A> editConfiguration(int index) {
    if (configurations.size() <= index) throw new RuntimeException("Can't edit configurations. Index exceeds size.");
    return setNewConfigurationLike(index, buildConfiguration(index));
  }
  
  public ConfigurationsNested<A> editFirstConfiguration() {
    if (configurations.size() == 0) throw new RuntimeException("Can't edit first configurations. The list is empty.");
    return setNewConfigurationLike(0, buildConfiguration(0));
  }
  
  public ConfigurationsNested<A> editLastConfiguration() {
    int index = configurations.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last configurations. The list is empty.");
    return setNewConfigurationLike(index, buildConfiguration(index));
  }
  
  public ConfigurationsNested<A> editMatchingConfiguration(Predicate<PrioritizerConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<configurations.size();i++) { 
    if (predicate.test(configurations.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching configurations. No match found.");
    return setNewConfigurationLike(index, buildConfiguration(index));
  }
  
  public String getMode() {
    return this.mode;
  }
  
  public A withMode(String mode) {
    this.mode=mode; return (A) this;
  }
  
  public boolean hasMode() {
    return this.mode != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PrioritizerPolicyFluent that = (PrioritizerPolicyFluent) o;
    if (!java.util.Objects.equals(configurations, that.configurations)) return false;
  
    if (!java.util.Objects.equals(mode, that.mode)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(configurations,  mode,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (configurations != null && !configurations.isEmpty()) { sb.append("configurations:"); sb.append(configurations + ","); }
    if (mode != null) { sb.append("mode:"); sb.append(mode); }
    sb.append("}");
    return sb.toString();
  }
  public class ConfigurationsNested<N> extends PrioritizerConfigFluent<ConfigurationsNested<N>> implements Nested<N>{
    ConfigurationsNested(int index,PrioritizerConfig item) {
      this.index = index;
      this.builder = new PrioritizerConfigBuilder(this, item);
    }
    PrioritizerConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) PrioritizerPolicyFluent.this.setToConfigurations(index,builder.build());
    }
    
    public N endConfiguration() {
      return and();
    }
    
  
  }

}